/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.gradle.lifecycle;

import co.elastic.gradle.lifecycle.ResolveAllDependenciesTask;
import co.elastic.gradle.utils.GradleUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class LifecyclePlugin
implements Plugin<Project> {
    protected static final String RESOLVE_ALL_DEPENDENCIES_TASK_NAME = "resolveAllDependencies";
    protected static final String PUBLISH_TASK_NAME = "publish";
    protected static final String SYNC_BIN_DIR_TASK_NAME = "syncBinDir";
    protected static final String PRE_COMMIT_TASK_NAME = "preCommit";
    protected static final String AUTO_FIX_TASK_NAME = "autoFix";
    protected static final String SECURITY_SCAN_TASK_NAME = "securityScan";

    public void apply(Project target) {
        TaskContainer tasks = target.getTasks();
        target.getPluginManager().apply(BasePlugin.class);
        TaskProvider publish = GradleUtils.registerOrGet((Project)target, (String)PUBLISH_TASK_NAME);
        publish.configure(task -> {
            task.setGroup("publishing");
            task.setDescription("Lifecycle task to publish build artefacts to external repos (e.g. Docker images)");
            task.dependsOn(new Object[]{tasks.named("build")});
        });
        tasks.register(RESOLVE_ALL_DEPENDENCIES_TASK_NAME, ResolveAllDependenciesTask.class);
        TaskProvider syncBinDir = tasks.register(SYNC_BIN_DIR_TASK_NAME, task -> {
            task.setGroup("utilities");
            task.setDescription("Lifecycle task to create links to \"bin dir\" that can be added to path so that tools used by Gradle can be used on the cli.");
        });
        tasks.named("check", task -> task.dependsOn(new Object[]{syncBinDir}));
        tasks.register(PRE_COMMIT_TASK_NAME, task -> {
            task.setGroup("verification");
            task.setDescription("Implements a set of \"quick\" checks, e.g. linting and compilation that one can use to keep the repository clean.");
        });
        tasks.register(AUTO_FIX_TASK_NAME, task -> {
            task.setGroup("automation");
            task.setDescription("Automatically fix some problems, e.g. run linters with the --fix option");
        });
        tasks.register(SECURITY_SCAN_TASK_NAME, task -> {
            task.setGroup("security");
            task.setDescription("Run all security scans");
        });
    }

    private static void whenPluginAddedAddDependency(Project target, TaskProvider<? extends Task> dependency, String taskName) {
        target.getPluginManager().withPlugin("co.elastic.lifecycle", p -> target.getTasks().named(taskName, task -> task.dependsOn(new Object[]{dependency})));
    }

    public static void resolveAllDependencies(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, RESOLVE_ALL_DEPENDENCIES_TASK_NAME);
    }

    public static void publish(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, PUBLISH_TASK_NAME);
    }

    public static void syncBinDir(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, SYNC_BIN_DIR_TASK_NAME);
    }

    public static void preCommit(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, PRE_COMMIT_TASK_NAME);
    }

    public static void check(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "check");
    }

    public static void assemble(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "assemble");
    }

    public static void clean(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "clean");
    }

    public static void autoFix(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, AUTO_FIX_TASK_NAME);
    }

    public static void securityScan(Project target, TaskProvider<? extends Task> dependency) {
        LifecyclePlugin.whenPluginAddedAddDependency(target, dependency, SECURITY_SCAN_TASK_NAME);
    }
}

