/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.gradle.cli.base;

import co.elastic.gradle.cli.base.BaseCliPlugin;
import co.elastic.gradle.utils.Architecture;
import co.elastic.gradle.utils.OS;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;

public abstract class MultipleSymlinkTask
extends DefaultTask {
    @Internal
    public Map<File, File> getNameToTargetMap() {
        Map<File, File> alternative;
        Configuration configuration = this.getProject().getConfigurations().getByName("static-cli");
        Set<String> allVersions = configuration.getDependencies().stream().map(Dependency::getVersion).collect(Collectors.toSet());
        HashMap<File, File> result = new HashMap<File, File>(configuration.getFiles().stream().collect(Collectors.toMap(value -> BaseCliPlugin.getExecutable(this.getProject(), this.normalizeName(value.getName(), allVersions)), Function.identity())));
        Map<File, File> currentArch = this.getDefaultSymlink(configuration, Architecture.current(), allVersions);
        if (!currentArch.isEmpty()) {
            result.putAll(currentArch);
            return result;
        }
        if (OS.current().equals((Object)OS.DARWIN) && !(alternative = this.getDefaultSymlink(configuration, Architecture.X86_64, allVersions)).isEmpty()) {
            result.putAll(alternative);
            return result;
        }
        throw new GradleException("Could not find the architecture specific binary from " + configuration.getFiles());
    }

    private String normalizeName(String targetName, Set<String> allVersions) {
        for (String version : allVersions) {
            targetName = targetName.replace("-" + version, "").replace("-v" + version, "").replace(version, "");
        }
        for (Architecture value : Architecture.values()) {
            targetName = targetName.replace(value.dockerName(), value.name().toLowerCase(Locale.ROOT)).replace(value.name(), value.name().toLowerCase(Locale.ROOT));
        }
        targetName = targetName.replace("macos", "darwin").replace("mac-386", "darwin-x86_64");
        return targetName;
    }

    private Map<File, File> getDefaultSymlink(Configuration configuration, Architecture arch, Set<String> allVersions) {
        return configuration.getFiles().stream().filter(value -> value.getName().toLowerCase(Locale.ROOT).contains(arch.name().toLowerCase(Locale.ROOT)) || value.getName().toLowerCase(Locale.ROOT).contains(arch.dockerName().toLowerCase(Locale.ROOT)) || value.getName().contains(OS.current().map(Map.of(OS.DARWIN, "mac")))).filter(value -> {
            boolean nameHasCurrentOS;
            boolean bl = nameHasCurrentOS = value.getName().contains(OS.current().name()) || value.getName().contains(OS.current().name().toLowerCase(Locale.ROOT)) || value.getName().contains(OS.current().map(Map.of(OS.DARWIN, "mac")));
            if (value.getName().toLowerCase(Locale.ROOT).contains(arch.name().toLowerCase(Locale.ROOT)) || value.getName().toLowerCase(Locale.ROOT).contains(arch.dockerName().toLowerCase(Locale.ROOT))) {
                return nameHasCurrentOS;
            }
            if (OS.current().equals((Object)OS.DARWIN)) {
                return nameHasCurrentOS;
            }
            return nameHasCurrentOS && arch.equals((Object)Architecture.X86_64);
        }).collect(Collectors.toMap(value -> {
            String name = value.getName();
            for (OS os : OS.values()) {
                for (String separator : List.of("-", ".")) {
                    name = name.replace(separator + os.name(), "").replace(separator + os.name().toLowerCase(Locale.ROOT), "").replace(separator + arch.name(), "").replace(separator + arch.name().toLowerCase(Locale.ROOT), "").replace(separator + arch.dockerName(), "").replace(separator + arch.dockerName().toUpperCase(Locale.ROOT), "").replace(separator + "macos", "").replace(separator + "osx", "").replace(separator + "mac-386", "");
                }
            }
            return BaseCliPlugin.getExecutable(this.getProject(), this.normalizeName(name, allVersions));
        }, Function.identity()));
    }

    @InputFiles
    public Set<File> getTarget() {
        return this.getNameToTargetMap().keySet();
    }

    @OutputFiles
    public Collection<File> getLinkName() {
        return this.getNameToTargetMap().values();
    }

    @TaskAction
    public void doLink() {
        this.getNameToTargetMap().forEach((linkName, target) -> {
            this.getLogger().lifecycle("Linking {}", new Object[]{linkName});
            Path linkPath = linkName.toPath();
            try {
                if (Files.exists(linkPath, new LinkOption[0])) {
                    Files.delete(linkPath);
                }
                if (!Files.exists(linkPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(linkPath.getParent(), new FileAttribute[0]);
                }
                Files.createSymbolicLink(linkPath, target.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

