/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.gradle.cli.base;

import co.elastic.gradle.cli.base.BaseCLiExtension;
import co.elastic.gradle.cli.base.CliExtension;
import co.elastic.gradle.cli.base.ExtractAndSetExecutableTransform;
import co.elastic.gradle.cli.base.MultipleSymlinkTask;
import co.elastic.gradle.lifecycle.LifecyclePlugin;
import co.elastic.gradle.utils.Architecture;
import co.elastic.gradle.utils.OS;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Locale;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;

public abstract class BaseCliPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_NAME = "static-cli";
    public static final String SYNC_TASK_NAME = "syncBinDirStaticCli";

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ProviderFactory getProviderFactory();

    public void apply(Project target) {
        target.getExtensions().create("cli", CliExtension.class, new Object[0]);
        if (target.getParent() != null) {
            target.getRootProject().getPluginManager().apply(BaseCliPlugin.class);
            return;
        }
        Configuration configuration = (Configuration)target.getConfigurations().create(CONFIGURATION_NAME);
        DependencyHandler dependencies = target.getDependencies();
        dependencies.registerTransform(ExtractAndSetExecutableTransform.class, config -> {
            config.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"transform");
            config.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"transform-extracted");
        });
        configuration.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"transform-extracted");
        TaskProvider syncBinDirStaticCli = target.getTasks().register(SYNC_TASK_NAME, MultipleSymlinkTask.class, task -> task.dependsOn(new Object[]{configuration}));
        LifecyclePlugin.syncBinDir((Project)target, (TaskProvider)syncBinDirStaticCli);
    }

    public static void addDownloadRepo(Project target, BaseCLiExtension extension) {
        target.afterEvaluate(p -> {
            URL url = (URL)extension.getBaseURL().get();
            Action credentialsAction = extension.getUsername().isPresent() && extension.getPassword().isPresent() ? config -> {
                config.setUsername((String)extension.getUsername().get());
                config.setPassword((String)extension.getPassword().get());
            } : null;
            target.getRootProject().getRepositories().ivy(repo -> {
                repo.setName(url.getHost() + "/" + url.getPath());
                repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
                repo.setUrl((Object)url);
                repo.patternLayout(config1 -> config1.artifact((String)extension.getPattern().get()));
                repo.content(content -> content.onlyForConfigurations(new String[]{CONFIGURATION_NAME}));
                if (credentialsAction != null) {
                    repo.credentials(credentialsAction);
                }
            });
        });
    }

    private static Path getPathToSyncedBinary(Project target, String name) {
        return target.getRootDir().toPath().resolve(".gradle/bin").resolve(name);
    }

    public static void addDependency(Project project, String dependencyNotation) {
        project.getRootProject().getDependencies().add(CONFIGURATION_NAME, (Object)(dependencyNotation + "@transform"));
    }

    public static File getExecutable(Project target, String artefactName, OS os, Architecture architecture) {
        return BaseCliPlugin.getPathToSyncedBinary(target.getRootProject(), artefactName + "-" + os.name().toLowerCase(Locale.ROOT) + "-" + architecture.name().toLowerCase(Locale.ROOT)).toFile();
    }

    public static File getExecutable(Project target, String artefactName) {
        return BaseCliPlugin.getPathToSyncedBinary(target.getRootProject(), artefactName).toFile();
    }
}

