/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.XpackUsageQuery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Sql
extends Base {
    private final Map<String, Integer> features;
    private final Map<String, XpackUsageQuery> queries;
    public static final JsonpDeserializer<Sql> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Sql::setupSqlDeserializer);

    private Sql(Builder builder) {
        super(builder);
        this.features = ApiTypeHelper.unmodifiableRequired(builder.features, (Object)this, "features");
        this.queries = ApiTypeHelper.unmodifiableRequired(builder.queries, (Object)this, "queries");
    }

    public static Sql of(Function<Builder, ObjectBuilder<Sql>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Integer> features() {
        return this.features;
    }

    public final Map<String, XpackUsageQuery> queries() {
        return this.queries;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.features)) {
            generator.writeKey("features");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> entry : this.features.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.queries)) {
            generator.writeKey("queries");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.queries.entrySet()) {
                generator.writeKey(entry.getKey());
                ((XpackUsageQuery)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSqlDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::features, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "features");
        op.add(Builder::queries, JsonpDeserializer.stringMapDeserializer(XpackUsageQuery._DESERIALIZER), "queries");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Sql> {
        private Map<String, Integer> features;
        private Map<String, XpackUsageQuery> queries;

        public Builder() {
        }

        private Builder(Sql instance) {
            this.features = instance.features;
            this.queries = instance.queries;
        }

        public final Builder features(Map<String, Integer> map) {
            this.features = Builder._mapPutAll(this.features, map);
            return this;
        }

        public final Builder features(String key, Integer value) {
            this.features = Builder._mapPut(this.features, key, value);
            return this;
        }

        public final Builder queries(Map<String, XpackUsageQuery> map) {
            this.queries = Builder._mapPutAll(this.queries, map);
            return this;
        }

        public final Builder queries(String key, XpackUsageQuery value) {
            this.queries = Builder._mapPut(this.queries, key, value);
            return this;
        }

        public final Builder queries(String key, Function<XpackUsageQuery.Builder, ObjectBuilder<XpackUsageQuery>> fn) {
            return this.queries(key, fn.apply(new XpackUsageQuery.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Sql build() {
            this._checkSingleUse();
            return new Sql(this);
        }
    }
}

