/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.transform.Destination;
import co.elastic.clients.elasticsearch.transform.Latest;
import co.elastic.clients.elasticsearch.transform.Pivot;
import co.elastic.clients.elasticsearch.transform.PutTransformResponse;
import co.elastic.clients.elasticsearch.transform.RetentionPolicy;
import co.elastic.clients.elasticsearch.transform.RetentionPolicyVariant;
import co.elastic.clients.elasticsearch.transform.Settings;
import co.elastic.clients.elasticsearch.transform.Source;
import co.elastic.clients.elasticsearch.transform.Sync;
import co.elastic.clients.elasticsearch.transform.SyncVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutTransformRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean deferValidation;
    @Nullable
    private final String description;
    private final Destination dest;
    @Nullable
    private final Time frequency;
    @Nullable
    private final Latest latest;
    @Nullable
    private final Pivot pivot;
    @Nullable
    private final RetentionPolicy retentionPolicy;
    @Nullable
    private final Settings settings;
    private final Source source;
    @Nullable
    private final Sync sync;
    @Nullable
    private final Time timeout;
    private final String transformId;
    public static final JsonpDeserializer<PutTransformRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTransformRequest::setupPutTransformRequestDeserializer);
    public static final Endpoint<PutTransformRequest, PutTransformResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutTransformRequest, PutTransformResponse>("es/transform.put_transform", request -> "PUT", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("transformId", request.transformId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.deferValidation != null) {
            params.put("defer_validation", String.valueOf(request.deferValidation));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutTransformResponse._DESERIALIZER);

    private PutTransformRequest(Builder builder) {
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.deferValidation = builder.deferValidation;
        this.description = builder.description;
        this.dest = ApiTypeHelper.requireNonNull(builder.dest, this, "dest");
        this.frequency = builder.frequency;
        this.latest = builder.latest;
        this.pivot = builder.pivot;
        this.retentionPolicy = builder.retentionPolicy;
        this.settings = builder.settings;
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.sync = builder.sync;
        this.timeout = builder.timeout;
        this.transformId = ApiTypeHelper.requireNonNull(builder.transformId, this, "transformId");
    }

    public static PutTransformRequest of(Function<Builder, ObjectBuilder<PutTransformRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean deferValidation() {
        return this.deferValidation;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final Destination dest() {
        return this.dest;
    }

    @Nullable
    public final Time frequency() {
        return this.frequency;
    }

    @Nullable
    public final Latest latest() {
        return this.latest;
    }

    @Nullable
    public final Pivot pivot() {
        return this.pivot;
    }

    @Nullable
    public final RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    @Nullable
    public final Settings settings() {
        return this.settings;
    }

    public final Source source() {
        return this.source;
    }

    @Nullable
    public final Sync sync() {
        return this.sync;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final String transformId() {
        return this.transformId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        if (this.frequency != null) {
            generator.writeKey("frequency");
            this.frequency.serialize(generator, mapper);
        }
        if (this.latest != null) {
            generator.writeKey("latest");
            this.latest.serialize(generator, mapper);
        }
        if (this.pivot != null) {
            generator.writeKey("pivot");
            this.pivot.serialize(generator, mapper);
        }
        if (this.retentionPolicy != null) {
            generator.writeKey("retention_policy");
            this.retentionPolicy.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        if (this.sync != null) {
            generator.writeKey("sync");
            this.sync.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutTransformRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dest, Destination._DESERIALIZER, "dest");
        op.add(Builder::frequency, Time._DESERIALIZER, "frequency");
        op.add(Builder::latest, Latest._DESERIALIZER, "latest");
        op.add(Builder::pivot, Pivot._DESERIALIZER, "pivot");
        op.add(Builder::retentionPolicy, RetentionPolicy._DESERIALIZER, "retention_policy");
        op.add(Builder::settings, Settings._DESERIALIZER, "settings");
        op.add(Builder::source, Source._DESERIALIZER, "source");
        op.add(Builder::sync, Sync._DESERIALIZER, "sync");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutTransformRequest> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean deferValidation;
        @Nullable
        private String description;
        private Destination dest;
        @Nullable
        private Time frequency;
        @Nullable
        private Latest latest;
        @Nullable
        private Pivot pivot;
        @Nullable
        private RetentionPolicy retentionPolicy;
        @Nullable
        private Settings settings;
        private Source source;
        @Nullable
        private Sync sync;
        @Nullable
        private Time timeout;
        private String transformId;

        public Builder() {
        }

        private Builder(PutTransformRequest instance) {
            this.meta = instance.meta;
            this.deferValidation = instance.deferValidation;
            this.description = instance.description;
            this.dest = instance.dest;
            this.frequency = instance.frequency;
            this.latest = instance.latest;
            this.pivot = instance.pivot;
            this.retentionPolicy = instance.retentionPolicy;
            this.settings = instance.settings;
            this.source = instance.source;
            this.sync = instance.sync;
            this.timeout = instance.timeout;
            this.transformId = instance.transformId;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder deferValidation(@Nullable Boolean value) {
            this.deferValidation = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder dest(Destination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<Destination.Builder, ObjectBuilder<Destination>> fn) {
            return this.dest(fn.apply(new Destination.Builder()).build());
        }

        public final Builder frequency(@Nullable Time value) {
            this.frequency = value;
            return this;
        }

        public final Builder frequency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.frequency(fn.apply(new Time.Builder()).build());
        }

        public final Builder latest(@Nullable Latest value) {
            this.latest = value;
            return this;
        }

        public final Builder latest(Function<Latest.Builder, ObjectBuilder<Latest>> fn) {
            return this.latest(fn.apply(new Latest.Builder()).build());
        }

        public final Builder pivot(@Nullable Pivot value) {
            this.pivot = value;
            return this;
        }

        public final Builder pivot(Function<Pivot.Builder, ObjectBuilder<Pivot>> fn) {
            return this.pivot(fn.apply(new Pivot.Builder()).build());
        }

        public final Builder retentionPolicy(@Nullable RetentionPolicy value) {
            this.retentionPolicy = value;
            return this;
        }

        public final Builder retentionPolicy(Function<RetentionPolicy.Builder, ObjectBuilder<RetentionPolicy>> fn) {
            return this.retentionPolicy(fn.apply(new RetentionPolicy.Builder()).build());
        }

        public final Builder retentionPolicy(RetentionPolicyVariant value) {
            this.retentionPolicy = value._toRetentionPolicy();
            return this;
        }

        public final Builder settings(@Nullable Settings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<Settings.Builder, ObjectBuilder<Settings>> fn) {
            return this.settings(fn.apply(new Settings.Builder()).build());
        }

        public final Builder source(Source value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<Source.Builder, ObjectBuilder<Source>> fn) {
            return this.source(fn.apply(new Source.Builder()).build());
        }

        public final Builder sync(@Nullable Sync value) {
            this.sync = value;
            return this;
        }

        public final Builder sync(Function<Sync.Builder, ObjectBuilder<Sync>> fn) {
            return this.sync(fn.apply(new Sync.Builder()).build());
        }

        public final Builder sync(SyncVariant value) {
            this.sync = value._toSync();
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutTransformRequest build() {
            this._checkSingleUse();
            return new PutTransformRequest(this);
        }
    }
}

