/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch.rollup.Metric;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class FieldMetric
implements JsonpSerializable {
    private final String field;
    private final List<Metric> metrics;
    public static final JsonpDeserializer<FieldMetric> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldMetric::setupFieldMetricDeserializer);

    private FieldMetric(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.metrics = ApiTypeHelper.unmodifiableRequired(builder.metrics, (Object)this, "metrics");
    }

    public static FieldMetric of(Function<Builder, ObjectBuilder<FieldMetric>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final List<Metric> metrics() {
        return this.metrics;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.metrics)) {
            generator.writeKey("metrics");
            generator.writeStartArray();
            for (Metric item0 : this.metrics) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFieldMetricDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(Metric._DESERIALIZER), "metrics");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldMetric> {
        private String field;
        private List<Metric> metrics;

        public Builder() {
        }

        private Builder(FieldMetric instance) {
            this.field = instance.field;
            this.metrics = instance.metrics;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder metrics(List<Metric> list) {
            this.metrics = Builder._listAddAll(this.metrics, list);
            return this;
        }

        public final Builder metrics(Metric value, Metric ... values) {
            this.metrics = Builder._listAdd(this.metrics, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldMetric build() {
            this._checkSingleUse();
            return new FieldMetric(this);
        }
    }
}

