/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.query_rules.GetRuleResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

public class GetRuleRequest
extends RequestBase {
    private final String ruleId;
    private final String rulesetId;
    public static final Endpoint<GetRuleRequest, GetRuleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetRuleRequest, GetRuleResponse>("es/query_rules.get_rule", request -> "GET", request -> {
        boolean _ruleId = true;
        int _rulesetId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_query_rules");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.rulesetId, buf);
            buf.append("/_rule");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.ruleId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _ruleId = true;
        int _rulesetId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("rulesetId", request.rulesetId);
            params.put("ruleId", request.ruleId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetRuleResponse._DESERIALIZER);

    private GetRuleRequest(Builder builder) {
        this.ruleId = ApiTypeHelper.requireNonNull(builder.ruleId, this, "ruleId");
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
    }

    public static GetRuleRequest of(Function<Builder, ObjectBuilder<GetRuleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetRuleRequest> {
        private String ruleId;
        private String rulesetId;

        public Builder() {
        }

        private Builder(GetRuleRequest instance) {
            this.ruleId = instance.ruleId;
            this.rulesetId = instance.rulesetId;
        }

        public final Builder ruleId(String value) {
            this.ruleId = value;
            return this;
        }

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetRuleRequest build() {
            this._checkSingleUse();
            return new GetRuleRequest(this);
        }
    }
}

