/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeReloadResult
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final ErrorCause reloadException;
    private final List<String> secureSettingNames;
    @Nullable
    private final String keystorePath;
    @Nullable
    private final String keystoreDigest;
    @Nullable
    private final DateTime keystoreLastModifiedTime;
    public static final JsonpDeserializer<NodeReloadResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeReloadResult::setupNodeReloadResultDeserializer);

    private NodeReloadResult(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.reloadException = builder.reloadException;
        this.secureSettingNames = ApiTypeHelper.unmodifiable(builder.secureSettingNames);
        this.keystorePath = builder.keystorePath;
        this.keystoreDigest = builder.keystoreDigest;
        this.keystoreLastModifiedTime = builder.keystoreLastModifiedTime;
    }

    public static NodeReloadResult of(Function<Builder, ObjectBuilder<NodeReloadResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final ErrorCause reloadException() {
        return this.reloadException;
    }

    public final List<String> secureSettingNames() {
        return this.secureSettingNames;
    }

    @Nullable
    public final String keystorePath() {
        return this.keystorePath;
    }

    @Nullable
    public final String keystoreDigest() {
        return this.keystoreDigest;
    }

    @Nullable
    public final DateTime keystoreLastModifiedTime() {
        return this.keystoreLastModifiedTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.reloadException != null) {
            generator.writeKey("reload_exception");
            this.reloadException.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.secureSettingNames)) {
            generator.writeKey("secure_setting_names");
            generator.writeStartArray();
            for (String item0 : this.secureSettingNames) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.keystorePath != null) {
            generator.writeKey("keystore_path");
            generator.write(this.keystorePath);
        }
        if (this.keystoreDigest != null) {
            generator.writeKey("keystore_digest");
            generator.write(this.keystoreDigest);
        }
        if (this.keystoreLastModifiedTime != null) {
            generator.writeKey("keystore_last_modified_time");
            this.keystoreLastModifiedTime.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNodeReloadResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::reloadException, ErrorCause._DESERIALIZER, "reload_exception");
        op.add(Builder::secureSettingNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "secure_setting_names");
        op.add(Builder::keystorePath, JsonpDeserializer.stringDeserializer(), "keystore_path");
        op.add(Builder::keystoreDigest, JsonpDeserializer.stringDeserializer(), "keystore_digest");
        op.add(Builder::keystoreLastModifiedTime, DateTime._DESERIALIZER, "keystore_last_modified_time");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeReloadResult> {
        private String name;
        @Nullable
        private ErrorCause reloadException;
        @Nullable
        private List<String> secureSettingNames;
        @Nullable
        private String keystorePath;
        @Nullable
        private String keystoreDigest;
        @Nullable
        private DateTime keystoreLastModifiedTime;

        public Builder() {
        }

        private Builder(NodeReloadResult instance) {
            this.name = instance.name;
            this.reloadException = instance.reloadException;
            this.secureSettingNames = instance.secureSettingNames;
            this.keystorePath = instance.keystorePath;
            this.keystoreDigest = instance.keystoreDigest;
            this.keystoreLastModifiedTime = instance.keystoreLastModifiedTime;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder reloadException(@Nullable ErrorCause value) {
            this.reloadException = value;
            return this;
        }

        public final Builder reloadException(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.reloadException(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder secureSettingNames(List<String> list) {
            this.secureSettingNames = Builder._listAddAll(this.secureSettingNames, list);
            return this;
        }

        public final Builder secureSettingNames(String value, String ... values) {
            this.secureSettingNames = Builder._listAdd(this.secureSettingNames, value, values);
            return this;
        }

        public final Builder keystorePath(@Nullable String value) {
            this.keystorePath = value;
            return this;
        }

        public final Builder keystoreDigest(@Nullable String value) {
            this.keystoreDigest = value;
            return this;
        }

        public final Builder keystoreLastModifiedTime(@Nullable DateTime value) {
            this.keystoreLastModifiedTime = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeReloadResult build() {
            this._checkSingleUse();
            return new NodeReloadResult(this);
        }
    }
}

