/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.get_memory_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MemMlStats
implements JsonpSerializable {
    @Nullable
    private final String anomalyDetectors;
    private final int anomalyDetectorsInBytes;
    @Nullable
    private final String dataFrameAnalytics;
    private final int dataFrameAnalyticsInBytes;
    @Nullable
    private final String max;
    private final int maxInBytes;
    @Nullable
    private final String nativeCodeOverhead;
    private final int nativeCodeOverheadInBytes;
    @Nullable
    private final String nativeInference;
    private final int nativeInferenceInBytes;
    public static final JsonpDeserializer<MemMlStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MemMlStats::setupMemMlStatsDeserializer);

    private MemMlStats(Builder builder) {
        this.anomalyDetectors = builder.anomalyDetectors;
        this.anomalyDetectorsInBytes = ApiTypeHelper.requireNonNull(builder.anomalyDetectorsInBytes, (Object)this, "anomalyDetectorsInBytes", 0);
        this.dataFrameAnalytics = builder.dataFrameAnalytics;
        this.dataFrameAnalyticsInBytes = ApiTypeHelper.requireNonNull(builder.dataFrameAnalyticsInBytes, (Object)this, "dataFrameAnalyticsInBytes", 0);
        this.max = builder.max;
        this.maxInBytes = ApiTypeHelper.requireNonNull(builder.maxInBytes, (Object)this, "maxInBytes", 0);
        this.nativeCodeOverhead = builder.nativeCodeOverhead;
        this.nativeCodeOverheadInBytes = ApiTypeHelper.requireNonNull(builder.nativeCodeOverheadInBytes, (Object)this, "nativeCodeOverheadInBytes", 0);
        this.nativeInference = builder.nativeInference;
        this.nativeInferenceInBytes = ApiTypeHelper.requireNonNull(builder.nativeInferenceInBytes, (Object)this, "nativeInferenceInBytes", 0);
    }

    public static MemMlStats of(Function<Builder, ObjectBuilder<MemMlStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String anomalyDetectors() {
        return this.anomalyDetectors;
    }

    public final int anomalyDetectorsInBytes() {
        return this.anomalyDetectorsInBytes;
    }

    @Nullable
    public final String dataFrameAnalytics() {
        return this.dataFrameAnalytics;
    }

    public final int dataFrameAnalyticsInBytes() {
        return this.dataFrameAnalyticsInBytes;
    }

    @Nullable
    public final String max() {
        return this.max;
    }

    public final int maxInBytes() {
        return this.maxInBytes;
    }

    @Nullable
    public final String nativeCodeOverhead() {
        return this.nativeCodeOverhead;
    }

    public final int nativeCodeOverheadInBytes() {
        return this.nativeCodeOverheadInBytes;
    }

    @Nullable
    public final String nativeInference() {
        return this.nativeInference;
    }

    public final int nativeInferenceInBytes() {
        return this.nativeInferenceInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.anomalyDetectors != null) {
            generator.writeKey("anomaly_detectors");
            generator.write(this.anomalyDetectors);
        }
        generator.writeKey("anomaly_detectors_in_bytes");
        generator.write(this.anomalyDetectorsInBytes);
        if (this.dataFrameAnalytics != null) {
            generator.writeKey("data_frame_analytics");
            generator.write(this.dataFrameAnalytics);
        }
        generator.writeKey("data_frame_analytics_in_bytes");
        generator.write(this.dataFrameAnalyticsInBytes);
        if (this.max != null) {
            generator.writeKey("max");
            generator.write(this.max);
        }
        generator.writeKey("max_in_bytes");
        generator.write(this.maxInBytes);
        if (this.nativeCodeOverhead != null) {
            generator.writeKey("native_code_overhead");
            generator.write(this.nativeCodeOverhead);
        }
        generator.writeKey("native_code_overhead_in_bytes");
        generator.write(this.nativeCodeOverheadInBytes);
        if (this.nativeInference != null) {
            generator.writeKey("native_inference");
            generator.write(this.nativeInference);
        }
        generator.writeKey("native_inference_in_bytes");
        generator.write(this.nativeInferenceInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMemMlStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::anomalyDetectors, JsonpDeserializer.stringDeserializer(), "anomaly_detectors");
        op.add(Builder::anomalyDetectorsInBytes, JsonpDeserializer.integerDeserializer(), "anomaly_detectors_in_bytes");
        op.add(Builder::dataFrameAnalytics, JsonpDeserializer.stringDeserializer(), "data_frame_analytics");
        op.add(Builder::dataFrameAnalyticsInBytes, JsonpDeserializer.integerDeserializer(), "data_frame_analytics_in_bytes");
        op.add(Builder::max, JsonpDeserializer.stringDeserializer(), "max");
        op.add(Builder::maxInBytes, JsonpDeserializer.integerDeserializer(), "max_in_bytes");
        op.add(Builder::nativeCodeOverhead, JsonpDeserializer.stringDeserializer(), "native_code_overhead");
        op.add(Builder::nativeCodeOverheadInBytes, JsonpDeserializer.integerDeserializer(), "native_code_overhead_in_bytes");
        op.add(Builder::nativeInference, JsonpDeserializer.stringDeserializer(), "native_inference");
        op.add(Builder::nativeInferenceInBytes, JsonpDeserializer.integerDeserializer(), "native_inference_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MemMlStats> {
        @Nullable
        private String anomalyDetectors;
        private Integer anomalyDetectorsInBytes;
        @Nullable
        private String dataFrameAnalytics;
        private Integer dataFrameAnalyticsInBytes;
        @Nullable
        private String max;
        private Integer maxInBytes;
        @Nullable
        private String nativeCodeOverhead;
        private Integer nativeCodeOverheadInBytes;
        @Nullable
        private String nativeInference;
        private Integer nativeInferenceInBytes;

        public Builder() {
        }

        private Builder(MemMlStats instance) {
            this.anomalyDetectors = instance.anomalyDetectors;
            this.anomalyDetectorsInBytes = instance.anomalyDetectorsInBytes;
            this.dataFrameAnalytics = instance.dataFrameAnalytics;
            this.dataFrameAnalyticsInBytes = instance.dataFrameAnalyticsInBytes;
            this.max = instance.max;
            this.maxInBytes = instance.maxInBytes;
            this.nativeCodeOverhead = instance.nativeCodeOverhead;
            this.nativeCodeOverheadInBytes = instance.nativeCodeOverheadInBytes;
            this.nativeInference = instance.nativeInference;
            this.nativeInferenceInBytes = instance.nativeInferenceInBytes;
        }

        public final Builder anomalyDetectors(@Nullable String value) {
            this.anomalyDetectors = value;
            return this;
        }

        public final Builder anomalyDetectorsInBytes(int value) {
            this.anomalyDetectorsInBytes = value;
            return this;
        }

        public final Builder dataFrameAnalytics(@Nullable String value) {
            this.dataFrameAnalytics = value;
            return this;
        }

        public final Builder dataFrameAnalyticsInBytes(int value) {
            this.dataFrameAnalyticsInBytes = value;
            return this;
        }

        public final Builder max(@Nullable String value) {
            this.max = value;
            return this;
        }

        public final Builder maxInBytes(int value) {
            this.maxInBytes = value;
            return this;
        }

        public final Builder nativeCodeOverhead(@Nullable String value) {
            this.nativeCodeOverhead = value;
            return this;
        }

        public final Builder nativeCodeOverheadInBytes(int value) {
            this.nativeCodeOverheadInBytes = value;
            return this;
        }

        public final Builder nativeInference(@Nullable String value) {
            this.nativeInference = value;
            return this;
        }

        public final Builder nativeInferenceInBytes(int value) {
            this.nativeInferenceInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MemMlStats build() {
            this._checkSingleUse();
            return new MemMlStats(this);
        }
    }
}

