/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelEntities
implements JsonpSerializable {
    private final String className;
    private final double classProbability;
    private final String entity;
    private final int startPos;
    private final int endPos;
    public static final JsonpDeserializer<TrainedModelEntities> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelEntities::setupTrainedModelEntitiesDeserializer);

    private TrainedModelEntities(Builder builder) {
        this.className = ApiTypeHelper.requireNonNull(builder.className, this, "className");
        this.classProbability = ApiTypeHelper.requireNonNull(builder.classProbability, (Object)this, "classProbability", 0.0);
        this.entity = ApiTypeHelper.requireNonNull(builder.entity, this, "entity");
        this.startPos = ApiTypeHelper.requireNonNull(builder.startPos, (Object)this, "startPos", 0);
        this.endPos = ApiTypeHelper.requireNonNull(builder.endPos, (Object)this, "endPos", 0);
    }

    public static TrainedModelEntities of(Function<Builder, ObjectBuilder<TrainedModelEntities>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String className() {
        return this.className;
    }

    public final double classProbability() {
        return this.classProbability;
    }

    public final String entity() {
        return this.entity;
    }

    public final int startPos() {
        return this.startPos;
    }

    public final int endPos() {
        return this.endPos;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("class_name");
        generator.write(this.className);
        generator.writeKey("class_probability");
        generator.write(this.classProbability);
        generator.writeKey("entity");
        generator.write(this.entity);
        generator.writeKey("start_pos");
        generator.write(this.startPos);
        generator.writeKey("end_pos");
        generator.write(this.endPos);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTrainedModelEntitiesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::className, JsonpDeserializer.stringDeserializer(), "class_name");
        op.add(Builder::classProbability, JsonpDeserializer.doubleDeserializer(), "class_probability");
        op.add(Builder::entity, JsonpDeserializer.stringDeserializer(), "entity");
        op.add(Builder::startPos, JsonpDeserializer.integerDeserializer(), "start_pos");
        op.add(Builder::endPos, JsonpDeserializer.integerDeserializer(), "end_pos");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelEntities> {
        private String className;
        private Double classProbability;
        private String entity;
        private Integer startPos;
        private Integer endPos;

        public Builder() {
        }

        private Builder(TrainedModelEntities instance) {
            this.className = instance.className;
            this.classProbability = instance.classProbability;
            this.entity = instance.entity;
            this.startPos = instance.startPos;
            this.endPos = instance.endPos;
        }

        public final Builder className(String value) {
            this.className = value;
            return this;
        }

        public final Builder classProbability(double value) {
            this.classProbability = value;
            return this;
        }

        public final Builder entity(String value) {
            this.entity = value;
            return this;
        }

        public final Builder startPos(int value) {
            this.startPos = value;
            return this;
        }

        public final Builder endPos(int value) {
            this.endPos = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelEntities build() {
            this._checkSingleUse();
            return new TrainedModelEntities(this);
        }
    }
}

