/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.StopDataFrameAnalyticsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StopDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean force;
    private final String id;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<StopDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StopDataFrameAnalyticsRequest::setupStopDataFrameAnalyticsRequestDeserializer);
    public static final Endpoint<StopDataFrameAnalyticsRequest, StopDataFrameAnalyticsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StopDataFrameAnalyticsRequest, StopDataFrameAnalyticsResponse>("es/ml.stop_data_frame_analytics", request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_stop");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("id", request.id);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, StopDataFrameAnalyticsResponse._DESERIALIZER);

    private StopDataFrameAnalyticsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.force = builder.force;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.timeout = builder.timeout;
    }

    public static StopDataFrameAnalyticsRequest of(Function<Builder, ObjectBuilder<StopDataFrameAnalyticsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Boolean force() {
        return this.force;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowNoMatch != null) {
            generator.writeKey("allow_no_match");
            generator.write(this.allowNoMatch.booleanValue());
        }
        if (this.force != null) {
            generator.writeKey("force");
            generator.write(this.force.booleanValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupStopDataFrameAnalyticsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowNoMatch, JsonpDeserializer.booleanDeserializer(), "allow_no_match");
        op.add(Builder::force, JsonpDeserializer.booleanDeserializer(), "force");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StopDataFrameAnalyticsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean force;
        private String id;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(StopDataFrameAnalyticsRequest instance) {
            this.allowNoMatch = instance.allowNoMatch;
            this.force = instance.force;
            this.id = instance.id;
            this.timeout = instance.timeout;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StopDataFrameAnalyticsRequest build() {
            this._checkSingleUse();
            return new StopDataFrameAnalyticsRequest(this);
        }
    }
}

