/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetTrainedModelsResponse;
import co.elastic.clients.elasticsearch.ml.Include;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetTrainedModelsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean decompressDefinition;
    @Nullable
    private final Boolean excludeGenerated;
    @Nullable
    private final Integer from;
    @Nullable
    private final Include include;
    private final List<String> modelId;
    @Nullable
    private final Integer size;
    private final List<String> tags;
    public static final Endpoint<GetTrainedModelsRequest, GetTrainedModelsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetTrainedModelsRequest, GetTrainedModelsResponse>("es/ml.get_trained_models", request -> "GET", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.modelId())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.modelId())) {
            propsSet |= true;
        }
        if (propsSet) {
            params.put("modelId", request.modelId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (!propsSet) {
            // empty if block
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.include != null) {
            params.put("include", request.include.jsonValue());
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.decompressDefinition != null) {
            params.put("decompress_definition", String.valueOf(request.decompressDefinition));
        }
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (ApiTypeHelper.isDefined(request.tags)) {
            params.put("tags", request.tags.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTrainedModelsResponse._DESERIALIZER);

    private GetTrainedModelsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.decompressDefinition = builder.decompressDefinition;
        this.excludeGenerated = builder.excludeGenerated;
        this.from = builder.from;
        this.include = builder.include;
        this.modelId = ApiTypeHelper.unmodifiable(builder.modelId);
        this.size = builder.size;
        this.tags = ApiTypeHelper.unmodifiable(builder.tags);
    }

    public static GetTrainedModelsRequest of(Function<Builder, ObjectBuilder<GetTrainedModelsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Boolean decompressDefinition() {
        return this.decompressDefinition;
    }

    @Nullable
    public final Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Include include() {
        return this.include;
    }

    public final List<String> modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<String> tags() {
        return this.tags;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetTrainedModelsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean decompressDefinition;
        @Nullable
        private Boolean excludeGenerated;
        @Nullable
        private Integer from;
        @Nullable
        private Include include;
        @Nullable
        private List<String> modelId;
        @Nullable
        private Integer size;
        @Nullable
        private List<String> tags;

        public Builder() {
        }

        private Builder(GetTrainedModelsRequest instance) {
            this.allowNoMatch = instance.allowNoMatch;
            this.decompressDefinition = instance.decompressDefinition;
            this.excludeGenerated = instance.excludeGenerated;
            this.from = instance.from;
            this.include = instance.include;
            this.modelId = instance.modelId;
            this.size = instance.size;
            this.tags = instance.tags;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder decompressDefinition(@Nullable Boolean value) {
            this.decompressDefinition = value;
            return this;
        }

        public final Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder include(@Nullable Include value) {
            this.include = value;
            return this;
        }

        public final Builder modelId(List<String> list) {
            this.modelId = Builder._listAddAll(this.modelId, list);
            return this;
        }

        public final Builder modelId(String value, String ... values) {
            this.modelId = Builder._listAdd(this.modelId, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder tags(List<String> list) {
            this.tags = Builder._listAddAll(this.tags, list);
            return this;
        }

        public final Builder tags(String value, String ... values) {
            this.tags = Builder._listAdd(this.tags, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetTrainedModelsRequest build() {
            this._checkSingleUse();
            return new GetTrainedModelsRequest(this);
        }
    }
}

