/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisBase;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeAnalysisClassification
extends DataframeAnalysisBase
implements DataframeAnalysisVariant {
    @Nullable
    private final String classAssignmentObjective;
    @Nullable
    private final Integer numTopClasses;
    public static final JsonpDeserializer<DataframeAnalysisClassification> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysisClassification::setupDataframeAnalysisClassificationDeserializer);

    private DataframeAnalysisClassification(Builder builder) {
        super(builder);
        this.classAssignmentObjective = builder.classAssignmentObjective;
        this.numTopClasses = builder.numTopClasses;
    }

    public static DataframeAnalysisClassification of(Function<Builder, ObjectBuilder<DataframeAnalysisClassification>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public DataframeAnalysis.Kind _dataframeAnalysisKind() {
        return DataframeAnalysis.Kind.Classification;
    }

    @Nullable
    public final String classAssignmentObjective() {
        return this.classAssignmentObjective;
    }

    @Nullable
    public final Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.classAssignmentObjective != null) {
            generator.writeKey("class_assignment_objective");
            generator.write(this.classAssignmentObjective);
        }
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataframeAnalysisClassificationDeserializer(ObjectDeserializer<Builder> op) {
        DataframeAnalysisBase.setupDataframeAnalysisBaseDeserializer(op);
        op.add(Builder::classAssignmentObjective, JsonpDeserializer.stringDeserializer(), "class_assignment_objective");
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes");
    }

    public static class Builder
    extends DataframeAnalysisBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DataframeAnalysisClassification> {
        @Nullable
        private String classAssignmentObjective;
        @Nullable
        private Integer numTopClasses;

        public Builder() {
        }

        private Builder(DataframeAnalysisClassification instance) {
            this.classAssignmentObjective = instance.classAssignmentObjective;
            this.numTopClasses = instance.numTopClasses;
        }

        public final Builder classAssignmentObjective(@Nullable String value) {
            this.classAssignmentObjective = value;
            return this;
        }

        public final Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalysisClassification build() {
            this._checkSingleUse();
            return new DataframeAnalysisClassification(this);
        }
    }
}

