/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration.deprecations;

import co.elastic.clients.elasticsearch.migration.deprecations.DeprecationLevel;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Deprecation
implements JsonpSerializable {
    @Nullable
    private final String details;
    private final DeprecationLevel level;
    private final String message;
    private final String url;
    private final boolean resolveDuringRollingUpgrade;
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<Deprecation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Deprecation::setupDeprecationDeserializer);

    private Deprecation(Builder builder) {
        this.details = builder.details;
        this.level = ApiTypeHelper.requireNonNull(builder.level, this, "level");
        this.message = ApiTypeHelper.requireNonNull(builder.message, this, "message");
        this.url = ApiTypeHelper.requireNonNull(builder.url, this, "url");
        this.resolveDuringRollingUpgrade = ApiTypeHelper.requireNonNull(builder.resolveDuringRollingUpgrade, (Object)this, "resolveDuringRollingUpgrade", false);
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
    }

    public static Deprecation of(Function<Builder, ObjectBuilder<Deprecation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String details() {
        return this.details;
    }

    public final DeprecationLevel level() {
        return this.level;
    }

    public final String message() {
        return this.message;
    }

    public final String url() {
        return this.url;
    }

    public final boolean resolveDuringRollingUpgrade() {
        return this.resolveDuringRollingUpgrade;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.details != null) {
            generator.writeKey("details");
            generator.write(this.details);
        }
        generator.writeKey("level");
        this.level.serialize(generator, mapper);
        generator.writeKey("message");
        generator.write(this.message);
        generator.writeKey("url");
        generator.write(this.url);
        generator.writeKey("resolve_during_rolling_upgrade");
        generator.write(this.resolveDuringRollingUpgrade);
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDeprecationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::details, JsonpDeserializer.stringDeserializer(), "details");
        op.add(Builder::level, DeprecationLevel._DESERIALIZER, "level");
        op.add(Builder::message, JsonpDeserializer.stringDeserializer(), "message");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
        op.add(Builder::resolveDuringRollingUpgrade, JsonpDeserializer.booleanDeserializer(), "resolve_during_rolling_upgrade");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Deprecation> {
        @Nullable
        private String details;
        private DeprecationLevel level;
        private String message;
        private String url;
        private Boolean resolveDuringRollingUpgrade;
        @Nullable
        private Map<String, JsonData> meta;

        public Builder() {
        }

        private Builder(Deprecation instance) {
            this.details = instance.details;
            this.level = instance.level;
            this.message = instance.message;
            this.url = instance.url;
            this.resolveDuringRollingUpgrade = instance.resolveDuringRollingUpgrade;
            this.meta = instance.meta;
        }

        public final Builder details(@Nullable String value) {
            this.details = value;
            return this;
        }

        public final Builder level(DeprecationLevel value) {
            this.level = value;
            return this;
        }

        public final Builder message(String value) {
            this.message = value;
            return this;
        }

        public final Builder url(String value) {
            this.url = value;
            return this;
        }

        public final Builder resolveDuringRollingUpgrade(boolean value) {
            this.resolveDuringRollingUpgrade = value;
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Deprecation build() {
            this._checkSingleUse();
            return new Deprecation(this);
        }
    }
}

