/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UriPartsProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Boolean keepOriginal;
    @Nullable
    private final Boolean removeIfSuccessful;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<UriPartsProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UriPartsProcessor::setupUriPartsProcessorDeserializer);

    private UriPartsProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.keepOriginal = builder.keepOriginal;
        this.removeIfSuccessful = builder.removeIfSuccessful;
        this.targetField = builder.targetField;
    }

    public static UriPartsProcessor of(Function<Builder, ObjectBuilder<UriPartsProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.UriParts;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final Boolean keepOriginal() {
        return this.keepOriginal;
    }

    @Nullable
    public final Boolean removeIfSuccessful() {
        return this.removeIfSuccessful;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.keepOriginal != null) {
            generator.writeKey("keep_original");
            generator.write(this.keepOriginal.booleanValue());
        }
        if (this.removeIfSuccessful != null) {
            generator.writeKey("remove_if_successful");
            generator.write(this.removeIfSuccessful.booleanValue());
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUriPartsProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::keepOriginal, JsonpDeserializer.booleanDeserializer(), "keep_original");
        op.add(Builder::removeIfSuccessful, JsonpDeserializer.booleanDeserializer(), "remove_if_successful");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UriPartsProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Boolean keepOriginal;
        @Nullable
        private Boolean removeIfSuccessful;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(UriPartsProcessor instance) {
            this.field = instance.field;
            this.ignoreMissing = instance.ignoreMissing;
            this.keepOriginal = instance.keepOriginal;
            this.removeIfSuccessful = instance.removeIfSuccessful;
            this.targetField = instance.targetField;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder keepOriginal(@Nullable Boolean value) {
            this.keepOriginal = value;
            return this;
        }

        public final Builder removeIfSuccessful(@Nullable Boolean value) {
            this.removeIfSuccessful = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UriPartsProcessor build() {
            this._checkSingleUse();
            return new UriPartsProcessor(this);
        }
    }
}

