/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CefProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final String targetField;
    @Nullable
    private final Boolean ignoreEmptyValues;
    @Nullable
    private final String timezone;
    public static final JsonpDeserializer<CefProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CefProcessor::setupCefProcessorDeserializer);

    private CefProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.targetField = builder.targetField;
        this.ignoreEmptyValues = builder.ignoreEmptyValues;
        this.timezone = builder.timezone;
    }

    public static CefProcessor of(Function<Builder, ObjectBuilder<CefProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Cef;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final Boolean ignoreEmptyValues() {
        return this.ignoreEmptyValues;
    }

    @Nullable
    public final String timezone() {
        return this.timezone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.ignoreEmptyValues != null) {
            generator.writeKey("ignore_empty_values");
            generator.write(this.ignoreEmptyValues.booleanValue());
        }
        if (this.timezone != null) {
            generator.writeKey("timezone");
            generator.write(this.timezone);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCefProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::ignoreEmptyValues, JsonpDeserializer.booleanDeserializer(), "ignore_empty_values");
        op.add(Builder::timezone, JsonpDeserializer.stringDeserializer(), "timezone");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CefProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private String targetField;
        @Nullable
        private Boolean ignoreEmptyValues;
        @Nullable
        private String timezone;

        public Builder() {
        }

        private Builder(CefProcessor instance) {
            this.field = instance.field;
            this.ignoreMissing = instance.ignoreMissing;
            this.targetField = instance.targetField;
            this.ignoreEmptyValues = instance.ignoreEmptyValues;
            this.timezone = instance.timezone;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder ignoreEmptyValues(@Nullable Boolean value) {
            this.ignoreEmptyValues = value;
            return this;
        }

        public final Builder timezone(@Nullable String value) {
            this.timezone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CefProcessor build() {
            this._checkSingleUse();
            return new CefProcessor(this);
        }
    }
}

