/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.ElasticsearchServiceSettings;
import co.elastic.clients.elasticsearch.inference.ElasticsearchServiceType;
import co.elastic.clients.elasticsearch.inference.ElasticsearchTaskSettings;
import co.elastic.clients.elasticsearch.inference.ElasticsearchTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutElasticsearchResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutElasticsearchRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String elasticsearchInferenceId;
    private final ElasticsearchServiceType service;
    private final ElasticsearchServiceSettings serviceSettings;
    @Nullable
    private final ElasticsearchTaskSettings taskSettings;
    private final ElasticsearchTaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutElasticsearchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutElasticsearchRequest::setupPutElasticsearchRequestDeserializer);
    public static final Endpoint<PutElasticsearchRequest, PutElasticsearchResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutElasticsearchRequest, PutElasticsearchResponse>("es/inference.put_elasticsearch", request -> "PUT", request -> {
        boolean _taskType = true;
        int _elasticsearchInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.elasticsearchInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _elasticsearchInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("elasticsearchInferenceId", request.elasticsearchInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutElasticsearchResponse._DESERIALIZER);

    private PutElasticsearchRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.elasticsearchInferenceId = ApiTypeHelper.requireNonNull(builder.elasticsearchInferenceId, this, "elasticsearchInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutElasticsearchRequest of(Function<Builder, ObjectBuilder<PutElasticsearchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String elasticsearchInferenceId() {
        return this.elasticsearchInferenceId;
    }

    public final ElasticsearchServiceType service() {
        return this.service;
    }

    public final ElasticsearchServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final ElasticsearchTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final ElasticsearchTaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutElasticsearchRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, ElasticsearchServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, ElasticsearchServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, ElasticsearchTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutElasticsearchRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String elasticsearchInferenceId;
        private ElasticsearchServiceType service;
        private ElasticsearchServiceSettings serviceSettings;
        @Nullable
        private ElasticsearchTaskSettings taskSettings;
        private ElasticsearchTaskType taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutElasticsearchRequest instance) {
            this.chunkingSettings = instance.chunkingSettings;
            this.elasticsearchInferenceId = instance.elasticsearchInferenceId;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder elasticsearchInferenceId(String value) {
            this.elasticsearchInferenceId = value;
            return this;
        }

        public final Builder service(ElasticsearchServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(ElasticsearchServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<ElasticsearchServiceSettings.Builder, ObjectBuilder<ElasticsearchServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new ElasticsearchServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable ElasticsearchTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<ElasticsearchTaskSettings.Builder, ObjectBuilder<ElasticsearchTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new ElasticsearchTaskSettings.Builder()).build());
        }

        public final Builder taskType(ElasticsearchTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutElasticsearchRequest build() {
            this._checkSingleUse();
            return new PutElasticsearchRequest(this);
        }
    }
}

