/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.OpenShiftAiSimilarityType;
import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OpenShiftAiServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    private final String url;
    @Nullable
    private final String modelId;
    @Nullable
    private final Integer maxInputTokens;
    @Nullable
    private final OpenShiftAiSimilarityType similarity;
    @Nullable
    private final RateLimitSetting rateLimit;
    public static final JsonpDeserializer<OpenShiftAiServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenShiftAiServiceSettings::setupOpenShiftAiServiceSettingsDeserializer);

    private OpenShiftAiServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.url = ApiTypeHelper.requireNonNull(builder.url, this, "url");
        this.modelId = builder.modelId;
        this.maxInputTokens = builder.maxInputTokens;
        this.similarity = builder.similarity;
        this.rateLimit = builder.rateLimit;
    }

    public static OpenShiftAiServiceSettings of(Function<Builder, ObjectBuilder<OpenShiftAiServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String url() {
        return this.url;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    @Nullable
    public final OpenShiftAiSimilarityType similarity() {
        return this.similarity;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        generator.writeKey("url");
        generator.write(this.url);
        if (this.modelId != null) {
            generator.writeKey("model_id");
            generator.write(this.modelId);
        }
        if (this.maxInputTokens != null) {
            generator.writeKey("max_input_tokens");
            generator.write(this.maxInputTokens.intValue());
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            this.similarity.serialize(generator, mapper);
        }
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupOpenShiftAiServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::maxInputTokens, JsonpDeserializer.integerDeserializer(), "max_input_tokens");
        op.add(Builder::similarity, OpenShiftAiSimilarityType._DESERIALIZER, "similarity");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OpenShiftAiServiceSettings> {
        private String apiKey;
        private String url;
        @Nullable
        private String modelId;
        @Nullable
        private Integer maxInputTokens;
        @Nullable
        private OpenShiftAiSimilarityType similarity;
        @Nullable
        private RateLimitSetting rateLimit;

        public Builder() {
        }

        private Builder(OpenShiftAiServiceSettings instance) {
            this.apiKey = instance.apiKey;
            this.url = instance.url;
            this.modelId = instance.modelId;
            this.maxInputTokens = instance.maxInputTokens;
            this.similarity = instance.similarity;
            this.rateLimit = instance.rateLimit;
        }

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder url(String value) {
            this.url = value;
            return this;
        }

        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public final Builder maxInputTokens(@Nullable Integer value) {
            this.maxInputTokens = value;
            return this;
        }

        public final Builder similarity(@Nullable OpenShiftAiSimilarityType value) {
            this.similarity = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OpenShiftAiServiceSettings build() {
            this._checkSingleUse();
            return new OpenShiftAiServiceSettings(this);
        }
    }
}

