/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OpenAITaskSettings
implements JsonpSerializable {
    @Nullable
    private final String user;
    @Nullable
    private final JsonData headers;
    public static final JsonpDeserializer<OpenAITaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenAITaskSettings::setupOpenAITaskSettingsDeserializer);

    private OpenAITaskSettings(Builder builder) {
        this.user = builder.user;
        this.headers = builder.headers;
    }

    public static OpenAITaskSettings of(Function<Builder, ObjectBuilder<OpenAITaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String user() {
        return this.user;
    }

    @Nullable
    public final JsonData headers() {
        return this.headers;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.user != null) {
            generator.writeKey("user");
            generator.write(this.user);
        }
        if (this.headers != null) {
            generator.writeKey("headers");
            this.headers.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupOpenAITaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::user, JsonpDeserializer.stringDeserializer(), "user");
        op.add(Builder::headers, JsonData._DESERIALIZER, "headers");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OpenAITaskSettings> {
        @Nullable
        private String user;
        @Nullable
        private JsonData headers;

        public Builder() {
        }

        private Builder(OpenAITaskSettings instance) {
            this.user = instance.user;
            this.headers = instance.headers;
        }

        public final Builder user(@Nullable String value) {
            this.user = value;
            return this;
        }

        public final Builder headers(@Nullable JsonData value) {
            this.headers = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OpenAITaskSettings build() {
            this._checkSingleUse();
            return new OpenAITaskSettings(this);
        }
    }
}

