/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.CustomRequestParams;
import co.elastic.clients.elasticsearch.inference.CustomResponseParams;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CustomServiceSettings
implements JsonpSerializable {
    @Nullable
    private final Integer batchSize;
    @Nullable
    private final JsonData headers;
    @Nullable
    private final JsonData inputType;
    @Nullable
    private final JsonData queryParameters;
    private final CustomRequestParams request;
    private final CustomResponseParams response;
    private final JsonData secretParameters;
    @Nullable
    private final String url;
    public static final JsonpDeserializer<CustomServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomServiceSettings::setupCustomServiceSettingsDeserializer);

    private CustomServiceSettings(Builder builder) {
        this.batchSize = builder.batchSize;
        this.headers = builder.headers;
        this.inputType = builder.inputType;
        this.queryParameters = builder.queryParameters;
        this.request = ApiTypeHelper.requireNonNull(builder.request, this, "request");
        this.response = ApiTypeHelper.requireNonNull(builder.response, this, "response");
        this.secretParameters = ApiTypeHelper.requireNonNull(builder.secretParameters, this, "secretParameters");
        this.url = builder.url;
    }

    public static CustomServiceSettings of(Function<Builder, ObjectBuilder<CustomServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer batchSize() {
        return this.batchSize;
    }

    @Nullable
    public final JsonData headers() {
        return this.headers;
    }

    @Nullable
    public final JsonData inputType() {
        return this.inputType;
    }

    @Nullable
    public final JsonData queryParameters() {
        return this.queryParameters;
    }

    public final CustomRequestParams request() {
        return this.request;
    }

    public final CustomResponseParams response() {
        return this.response;
    }

    public final JsonData secretParameters() {
        return this.secretParameters;
    }

    @Nullable
    public final String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.batchSize != null) {
            generator.writeKey("batch_size");
            generator.write(this.batchSize.intValue());
        }
        if (this.headers != null) {
            generator.writeKey("headers");
            this.headers.serialize(generator, mapper);
        }
        if (this.inputType != null) {
            generator.writeKey("input_type");
            this.inputType.serialize(generator, mapper);
        }
        if (this.queryParameters != null) {
            generator.writeKey("query_parameters");
            this.queryParameters.serialize(generator, mapper);
        }
        generator.writeKey("request");
        this.request.serialize(generator, mapper);
        generator.writeKey("response");
        this.response.serialize(generator, mapper);
        generator.writeKey("secret_parameters");
        this.secretParameters.serialize(generator, mapper);
        if (this.url != null) {
            generator.writeKey("url");
            generator.write(this.url);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCustomServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::batchSize, JsonpDeserializer.integerDeserializer(), "batch_size");
        op.add(Builder::headers, JsonData._DESERIALIZER, "headers");
        op.add(Builder::inputType, JsonData._DESERIALIZER, "input_type");
        op.add(Builder::queryParameters, JsonData._DESERIALIZER, "query_parameters");
        op.add(Builder::request, CustomRequestParams._DESERIALIZER, "request");
        op.add(Builder::response, CustomResponseParams._DESERIALIZER, "response");
        op.add(Builder::secretParameters, JsonData._DESERIALIZER, "secret_parameters");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CustomServiceSettings> {
        @Nullable
        private Integer batchSize;
        @Nullable
        private JsonData headers;
        @Nullable
        private JsonData inputType;
        @Nullable
        private JsonData queryParameters;
        private CustomRequestParams request;
        private CustomResponseParams response;
        private JsonData secretParameters;
        @Nullable
        private String url;

        public Builder() {
        }

        private Builder(CustomServiceSettings instance) {
            this.batchSize = instance.batchSize;
            this.headers = instance.headers;
            this.inputType = instance.inputType;
            this.queryParameters = instance.queryParameters;
            this.request = instance.request;
            this.response = instance.response;
            this.secretParameters = instance.secretParameters;
            this.url = instance.url;
        }

        public final Builder batchSize(@Nullable Integer value) {
            this.batchSize = value;
            return this;
        }

        public final Builder headers(@Nullable JsonData value) {
            this.headers = value;
            return this;
        }

        public final Builder inputType(@Nullable JsonData value) {
            this.inputType = value;
            return this;
        }

        public final Builder queryParameters(@Nullable JsonData value) {
            this.queryParameters = value;
            return this;
        }

        public final Builder request(CustomRequestParams value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<CustomRequestParams.Builder, ObjectBuilder<CustomRequestParams>> fn) {
            return this.request(fn.apply(new CustomRequestParams.Builder()).build());
        }

        public final Builder response(CustomResponseParams value) {
            this.response = value;
            return this;
        }

        public final Builder response(Function<CustomResponseParams.Builder, ObjectBuilder<CustomResponseParams>> fn) {
            return this.response(fn.apply(new CustomResponseParams.Builder()).build());
        }

        public final Builder secretParameters(JsonData value) {
            this.secretParameters = value;
            return this;
        }

        public final Builder url(@Nullable String value) {
            this.url = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CustomServiceSettings build() {
            this._checkSingleUse();
            return new CustomServiceSettings(this);
        }
    }
}

