/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardSequenceNumber
implements JsonpSerializable {
    private final long globalCheckpoint;
    private final long localCheckpoint;
    private final long maxSeqNo;
    public static final JsonpDeserializer<ShardSequenceNumber> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSequenceNumber::setupShardSequenceNumberDeserializer);

    private ShardSequenceNumber(Builder builder) {
        this.globalCheckpoint = ApiTypeHelper.requireNonNull(builder.globalCheckpoint, (Object)this, "globalCheckpoint", 0L);
        this.localCheckpoint = ApiTypeHelper.requireNonNull(builder.localCheckpoint, (Object)this, "localCheckpoint", 0L);
        this.maxSeqNo = ApiTypeHelper.requireNonNull(builder.maxSeqNo, (Object)this, "maxSeqNo", 0L);
    }

    public static ShardSequenceNumber of(Function<Builder, ObjectBuilder<ShardSequenceNumber>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long globalCheckpoint() {
        return this.globalCheckpoint;
    }

    public final long localCheckpoint() {
        return this.localCheckpoint;
    }

    public final long maxSeqNo() {
        return this.maxSeqNo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("global_checkpoint");
        generator.write(this.globalCheckpoint);
        generator.writeKey("local_checkpoint");
        generator.write(this.localCheckpoint);
        generator.writeKey("max_seq_no");
        generator.write(this.maxSeqNo);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupShardSequenceNumberDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::globalCheckpoint, JsonpDeserializer.longDeserializer(), "global_checkpoint");
        op.add(Builder::localCheckpoint, JsonpDeserializer.longDeserializer(), "local_checkpoint");
        op.add(Builder::maxSeqNo, JsonpDeserializer.longDeserializer(), "max_seq_no");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardSequenceNumber> {
        private Long globalCheckpoint;
        private Long localCheckpoint;
        private Long maxSeqNo;

        public Builder() {
        }

        private Builder(ShardSequenceNumber instance) {
            this.globalCheckpoint = instance.globalCheckpoint;
            this.localCheckpoint = instance.localCheckpoint;
            this.maxSeqNo = instance.maxSeqNo;
        }

        public final Builder globalCheckpoint(long value) {
            this.globalCheckpoint = value;
            return this;
        }

        public final Builder localCheckpoint(long value) {
            this.localCheckpoint = value;
            return this;
        }

        public final Builder maxSeqNo(long value) {
            this.maxSeqNo = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardSequenceNumber build() {
            this._checkSingleUse();
            return new ShardSequenceNumber(this);
        }
    }
}

