/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.PutDataStreamMappingsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDataStreamMappingsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean dryRun;
    @Nullable
    private final Time masterTimeout;
    private final List<String> name;
    @Nullable
    private final Time timeout;
    private final TypeMapping mappings;
    public static final JsonpDeserializer<PutDataStreamMappingsRequest> _DESERIALIZER = PutDataStreamMappingsRequest.createPutDataStreamMappingsRequestDeserializer();
    public static final Endpoint<PutDataStreamMappingsRequest, PutDataStreamMappingsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutDataStreamMappingsRequest, PutDataStreamMappingsResponse>("es/indices.put_data_stream_mappings", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mappings");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.dryRun != null) {
            params.put("dry_run", String.valueOf(request.dryRun));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutDataStreamMappingsResponse._DESERIALIZER);

    private PutDataStreamMappingsRequest(Builder builder) {
        this.dryRun = builder.dryRun;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
        this.timeout = builder.timeout;
        this.mappings = ApiTypeHelper.requireNonNull(builder.mappings, this, "mappings");
    }

    public static PutDataStreamMappingsRequest of(Function<Builder, ObjectBuilder<PutDataStreamMappingsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> name() {
        return this.name;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.mappings.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static JsonpDeserializer<PutDataStreamMappingsRequest> createPutDataStreamMappingsRequestDeserializer() {
        JsonpDeserializer<TypeMapping> valueDeserializer = TypeMapping._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().mappings((TypeMapping)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutDataStreamMappingsRequest> {
        @Nullable
        private Boolean dryRun;
        @Nullable
        private Time masterTimeout;
        private List<String> name;
        @Nullable
        private Time timeout;
        private TypeMapping mappings;

        public Builder() {
        }

        private Builder(PutDataStreamMappingsRequest instance) {
            this.dryRun = instance.dryRun;
            this.masterTimeout = instance.masterTimeout;
            this.name = instance.name;
            this.timeout = instance.timeout;
            this.mappings = instance.mappings;
        }

        public final Builder dryRun(@Nullable Boolean value) {
            this.dryRun = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            TypeMapping value = TypeMapping._DESERIALIZER.deserialize(parser, mapper);
            return this.mappings(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDataStreamMappingsRequest build() {
            this._checkSingleUse();
            return new PutDataStreamMappingsRequest(this);
        }
    }
}

