/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DownsamplingRound;
import co.elastic.clients.elasticsearch.indices.PutDataLifecycleResponse;
import co.elastic.clients.elasticsearch.indices.SamplingMethod;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDataLifecycleRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time dataRetention;
    private final List<DownsamplingRound> downsampling;
    @Nullable
    private final SamplingMethod downsamplingMethod;
    @Nullable
    private final Boolean enabled;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Time masterTimeout;
    private final List<String> name;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutDataLifecycleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDataLifecycleRequest::setupPutDataLifecycleRequestDeserializer);
    public static final Endpoint<PutDataLifecycleRequest, PutDataLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutDataLifecycleRequest, PutDataLifecycleResponse>("es/indices.put_data_lifecycle", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_lifecycle");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutDataLifecycleResponse._DESERIALIZER);

    private PutDataLifecycleRequest(Builder builder) {
        this.dataRetention = builder.dataRetention;
        this.downsampling = ApiTypeHelper.unmodifiable(builder.downsampling);
        this.downsamplingMethod = builder.downsamplingMethod;
        this.enabled = builder.enabled;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
        this.timeout = builder.timeout;
    }

    public static PutDataLifecycleRequest of(Function<Builder, ObjectBuilder<PutDataLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time dataRetention() {
        return this.dataRetention;
    }

    public final List<DownsamplingRound> downsampling() {
        return this.downsampling;
    }

    @Nullable
    public final SamplingMethod downsamplingMethod() {
        return this.downsamplingMethod;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> name() {
        return this.name;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dataRetention != null) {
            generator.writeKey("data_retention");
            this.dataRetention.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.downsampling)) {
            generator.writeKey("downsampling");
            generator.writeStartArray();
            for (DownsamplingRound item0 : this.downsampling) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.downsamplingMethod != null) {
            generator.writeKey("downsampling_method");
            this.downsamplingMethod.serialize(generator, mapper);
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutDataLifecycleRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataRetention, Time._DESERIALIZER, "data_retention");
        op.add(Builder::downsampling, JsonpDeserializer.arrayDeserializer(DownsamplingRound._DESERIALIZER), "downsampling");
        op.add(Builder::downsamplingMethod, SamplingMethod._DESERIALIZER, "downsampling_method");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutDataLifecycleRequest> {
        @Nullable
        private Time dataRetention;
        @Nullable
        private List<DownsamplingRound> downsampling;
        @Nullable
        private SamplingMethod downsamplingMethod;
        @Nullable
        private Boolean enabled;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Time masterTimeout;
        private List<String> name;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutDataLifecycleRequest instance) {
            this.dataRetention = instance.dataRetention;
            this.downsampling = instance.downsampling;
            this.downsamplingMethod = instance.downsamplingMethod;
            this.enabled = instance.enabled;
            this.expandWildcards = instance.expandWildcards;
            this.masterTimeout = instance.masterTimeout;
            this.name = instance.name;
            this.timeout = instance.timeout;
        }

        public final Builder dataRetention(@Nullable Time value) {
            this.dataRetention = value;
            return this;
        }

        public final Builder dataRetention(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.dataRetention(fn.apply(new Time.Builder()).build());
        }

        public final Builder downsampling(List<DownsamplingRound> list) {
            this.downsampling = Builder._listAddAll(this.downsampling, list);
            return this;
        }

        public final Builder downsampling(DownsamplingRound value, DownsamplingRound ... values) {
            this.downsampling = Builder._listAdd(this.downsampling, value, values);
            return this;
        }

        public final Builder downsampling(Function<DownsamplingRound.Builder, ObjectBuilder<DownsamplingRound>> fn) {
            return this.downsampling(fn.apply(new DownsamplingRound.Builder()).build(), new DownsamplingRound[0]);
        }

        public final Builder downsamplingMethod(@Nullable SamplingMethod value) {
            this.downsamplingMethod = value;
            return this;
        }

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDataLifecycleRequest build() {
            this._checkSingleUse();
            return new PutDataLifecycleRequest(this);
        }
    }
}

