/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.ModifyDataStreamResponse;
import co.elastic.clients.elasticsearch.indices.modify_data_stream.Action;
import co.elastic.clients.elasticsearch.indices.modify_data_stream.ActionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ModifyDataStreamRequest
extends RequestBase
implements JsonpSerializable {
    private final List<Action> actions;
    public static final JsonpDeserializer<ModifyDataStreamRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModifyDataStreamRequest::setupModifyDataStreamRequestDeserializer);
    public static final Endpoint<ModifyDataStreamRequest, ModifyDataStreamResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ModifyDataStreamRequest, ModifyDataStreamResponse>("es/indices.modify_data_stream", request -> "POST", request -> "/_data_stream/_modify", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ModifyDataStreamResponse._DESERIALIZER);

    private ModifyDataStreamRequest(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiableRequired(builder.actions, (Object)this, "actions");
    }

    public static ModifyDataStreamRequest of(Function<Builder, ObjectBuilder<ModifyDataStreamRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Action> actions() {
        return this.actions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (Action item0 : this.actions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupModifyDataStreamRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(Action._DESERIALIZER), "actions");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ModifyDataStreamRequest> {
        private List<Action> actions;

        public Builder() {
        }

        private Builder(ModifyDataStreamRequest instance) {
            this.actions = instance.actions;
        }

        public final Builder actions(List<Action> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        public final Builder actions(Action value, Action ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        public final Builder actions(ActionVariant value, ActionVariant ... values) {
            this.actions = Builder._listAdd(this.actions, value._toAction(), new Action[0]);
            for (ActionVariant v : values) {
                Builder._listAdd(this.actions, v._toAction(), new Action[0]);
            }
            return this;
        }

        public final Builder actions(Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.actions(fn.apply(new Action.Builder()).build(), new Action[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ModifyDataStreamRequest build() {
            this._checkSingleUse();
            return new ModifyDataStreamRequest(this);
        }
    }
}

