/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.IndexTemplateDataStreamConfiguration;
import co.elastic.clients.elasticsearch.indices.IndexTemplateSummary;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexTemplate
implements JsonpSerializable {
    private final List<String> indexPatterns;
    private final List<String> composedOf;
    @Nullable
    private final IndexTemplateSummary template;
    @Nullable
    private final Long version;
    @Nullable
    private final Long priority;
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean allowAutoCreate;
    @Nullable
    private final IndexTemplateDataStreamConfiguration dataStream;
    @Nullable
    private final Boolean deprecated;
    private final List<String> ignoreMissingComponentTemplates;
    @Nullable
    private final DateTime createdDate;
    @Nullable
    private final Long createdDateMillis;
    @Nullable
    private final DateTime modifiedDate;
    @Nullable
    private final Long modifiedDateMillis;
    public static final JsonpDeserializer<IndexTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexTemplate::setupIndexTemplateDeserializer);

    private IndexTemplate(Builder builder) {
        this.indexPatterns = ApiTypeHelper.unmodifiableRequired(builder.indexPatterns, (Object)this, "indexPatterns");
        this.composedOf = ApiTypeHelper.unmodifiableRequired(builder.composedOf, (Object)this, "composedOf");
        this.template = builder.template;
        this.version = builder.version;
        this.priority = builder.priority;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.allowAutoCreate = builder.allowAutoCreate;
        this.dataStream = builder.dataStream;
        this.deprecated = builder.deprecated;
        this.ignoreMissingComponentTemplates = ApiTypeHelper.unmodifiable(builder.ignoreMissingComponentTemplates);
        this.createdDate = builder.createdDate;
        this.createdDateMillis = builder.createdDateMillis;
        this.modifiedDate = builder.modifiedDate;
        this.modifiedDateMillis = builder.modifiedDateMillis;
    }

    public static IndexTemplate of(Function<Builder, ObjectBuilder<IndexTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    public final List<String> composedOf() {
        return this.composedOf;
    }

    @Nullable
    public final IndexTemplateSummary template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final Long priority() {
        return this.priority;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean allowAutoCreate() {
        return this.allowAutoCreate;
    }

    @Nullable
    public final IndexTemplateDataStreamConfiguration dataStream() {
        return this.dataStream;
    }

    @Nullable
    public final Boolean deprecated() {
        return this.deprecated;
    }

    public final List<String> ignoreMissingComponentTemplates() {
        return this.ignoreMissingComponentTemplates;
    }

    @Nullable
    public final DateTime createdDate() {
        return this.createdDate;
    }

    @Nullable
    public final Long createdDateMillis() {
        return this.createdDateMillis;
    }

    @Nullable
    public final DateTime modifiedDate() {
        return this.modifiedDate;
    }

    @Nullable
    public final Long modifiedDateMillis() {
        return this.modifiedDateMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.composedOf)) {
            generator.writeKey("composed_of");
            generator.writeStartArray();
            for (String string : this.composedOf) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.longValue());
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.allowAutoCreate != null) {
            generator.writeKey("allow_auto_create");
            generator.write(this.allowAutoCreate.booleanValue());
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            this.dataStream.serialize(generator, mapper);
        }
        if (this.deprecated != null) {
            generator.writeKey("deprecated");
            generator.write(this.deprecated.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.ignoreMissingComponentTemplates)) {
            generator.writeKey("ignore_missing_component_templates");
            generator.writeStartArray();
            for (String string : this.ignoreMissingComponentTemplates) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.createdDate != null) {
            generator.writeKey("created_date");
            this.createdDate.serialize(generator, mapper);
        }
        if (this.createdDateMillis != null) {
            generator.writeKey("created_date_millis");
            generator.write(this.createdDateMillis.longValue());
        }
        if (this.modifiedDate != null) {
            generator.writeKey("modified_date");
            this.modifiedDate.serialize(generator, mapper);
        }
        if (this.modifiedDateMillis != null) {
            generator.writeKey("modified_date_millis");
            generator.write(this.modifiedDateMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIndexTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of");
        op.add(Builder::template, IndexTemplateSummary._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::priority, JsonpDeserializer.longDeserializer(), "priority");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::allowAutoCreate, JsonpDeserializer.booleanDeserializer(), "allow_auto_create");
        op.add(Builder::dataStream, IndexTemplateDataStreamConfiguration._DESERIALIZER, "data_stream");
        op.add(Builder::deprecated, JsonpDeserializer.booleanDeserializer(), "deprecated");
        op.add(Builder::ignoreMissingComponentTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ignore_missing_component_templates");
        op.add(Builder::createdDate, DateTime._DESERIALIZER, "created_date");
        op.add(Builder::createdDateMillis, JsonpDeserializer.longDeserializer(), "created_date_millis");
        op.add(Builder::modifiedDate, DateTime._DESERIALIZER, "modified_date");
        op.add(Builder::modifiedDateMillis, JsonpDeserializer.longDeserializer(), "modified_date_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexTemplate> {
        private List<String> indexPatterns;
        private List<String> composedOf;
        @Nullable
        private IndexTemplateSummary template;
        @Nullable
        private Long version;
        @Nullable
        private Long priority;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean allowAutoCreate;
        @Nullable
        private IndexTemplateDataStreamConfiguration dataStream;
        @Nullable
        private Boolean deprecated;
        @Nullable
        private List<String> ignoreMissingComponentTemplates;
        @Nullable
        private DateTime createdDate;
        @Nullable
        private Long createdDateMillis;
        @Nullable
        private DateTime modifiedDate;
        @Nullable
        private Long modifiedDateMillis;

        public Builder() {
        }

        private Builder(IndexTemplate instance) {
            this.indexPatterns = instance.indexPatterns;
            this.composedOf = instance.composedOf;
            this.template = instance.template;
            this.version = instance.version;
            this.priority = instance.priority;
            this.meta = instance.meta;
            this.allowAutoCreate = instance.allowAutoCreate;
            this.dataStream = instance.dataStream;
            this.deprecated = instance.deprecated;
            this.ignoreMissingComponentTemplates = instance.ignoreMissingComponentTemplates;
            this.createdDate = instance.createdDate;
            this.createdDateMillis = instance.createdDateMillis;
            this.modifiedDate = instance.modifiedDate;
            this.modifiedDateMillis = instance.modifiedDateMillis;
        }

        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        public final Builder composedOf(List<String> list) {
            this.composedOf = Builder._listAddAll(this.composedOf, list);
            return this;
        }

        public final Builder composedOf(String value, String ... values) {
            this.composedOf = Builder._listAdd(this.composedOf, value, values);
            return this;
        }

        public final Builder template(@Nullable IndexTemplateSummary value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<IndexTemplateSummary.Builder, ObjectBuilder<IndexTemplateSummary>> fn) {
            return this.template(fn.apply(new IndexTemplateSummary.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder priority(@Nullable Long value) {
            this.priority = value;
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder allowAutoCreate(@Nullable Boolean value) {
            this.allowAutoCreate = value;
            return this;
        }

        public final Builder dataStream(@Nullable IndexTemplateDataStreamConfiguration value) {
            this.dataStream = value;
            return this;
        }

        public final Builder dataStream(Function<IndexTemplateDataStreamConfiguration.Builder, ObjectBuilder<IndexTemplateDataStreamConfiguration>> fn) {
            return this.dataStream(fn.apply(new IndexTemplateDataStreamConfiguration.Builder()).build());
        }

        public final Builder deprecated(@Nullable Boolean value) {
            this.deprecated = value;
            return this;
        }

        public final Builder ignoreMissingComponentTemplates(List<String> list) {
            this.ignoreMissingComponentTemplates = Builder._listAddAll(this.ignoreMissingComponentTemplates, list);
            return this;
        }

        public final Builder ignoreMissingComponentTemplates(String value, String ... values) {
            this.ignoreMissingComponentTemplates = Builder._listAdd(this.ignoreMissingComponentTemplates, value, values);
            return this;
        }

        public final Builder createdDate(@Nullable DateTime value) {
            this.createdDate = value;
            return this;
        }

        public final Builder createdDateMillis(@Nullable Long value) {
            this.createdDateMillis = value;
            return this;
        }

        public final Builder modifiedDate(@Nullable DateTime value) {
            this.modifiedDate = value;
            return this;
        }

        public final Builder modifiedDateMillis(@Nullable Long value) {
            this.modifiedDateMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexTemplate build() {
            this._checkSingleUse();
            return new IndexTemplate(this);
        }
    }
}

