/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.esql;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ESQLView
implements JsonpSerializable {
    private final String name;
    private final String query;
    public static final JsonpDeserializer<ESQLView> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ESQLView::setupESQLViewDeserializer);

    private ESQLView(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static ESQLView of(Function<Builder, ObjectBuilder<ESQLView>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("query");
        generator.write(this.query);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupESQLViewDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ESQLView> {
        private String name;
        private String query;

        public Builder() {
        }

        private Builder(ESQLView instance) {
            this.name = instance.name;
            this.query = instance.query;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ESQLView build() {
            this._checkSingleUse();
            return new ESQLView(this);
        }
    }
}

