/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RegexOptions
implements JsonpSerializable {
    @Nullable
    private final String flags;
    @Nullable
    private final Integer maxDeterminizedStates;
    public static final JsonpDeserializer<RegexOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RegexOptions::setupRegexOptionsDeserializer);

    private RegexOptions(Builder builder) {
        this.flags = builder.flags;
        this.maxDeterminizedStates = builder.maxDeterminizedStates;
    }

    public static RegexOptions of(Function<Builder, ObjectBuilder<RegexOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String flags() {
        return this.flags;
    }

    @Nullable
    public final Integer maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.flags != null) {
            generator.writeKey("flags");
            generator.write(this.flags);
        }
        if (this.maxDeterminizedStates != null) {
            generator.writeKey("max_determinized_states");
            generator.write(this.maxDeterminizedStates.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRegexOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::maxDeterminizedStates, JsonpDeserializer.integerDeserializer(), "max_determinized_states");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RegexOptions> {
        @Nullable
        private String flags;
        @Nullable
        private Integer maxDeterminizedStates;

        public Builder() {
        }

        private Builder(RegexOptions instance) {
            this.flags = instance.flags;
            this.maxDeterminizedStates = instance.maxDeterminizedStates;
        }

        public final Builder flags(@Nullable String value) {
            this.flags = value;
            return this;
        }

        public final Builder maxDeterminizedStates(@Nullable Integer value) {
            this.maxDeterminizedStates = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RegexOptions build() {
            this._checkSingleUse();
            return new RegexOptions(this);
        }
    }
}

