/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.search.TrackHits;
import co.elastic.clients.elasticsearch.core.search_mvt.GridAggregationType;
import co.elastic.clients.elasticsearch.core.search_mvt.GridType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.BinaryEndpoint;
import co.elastic.clients.transport.endpoints.BinaryResponse;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchMvtRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, Aggregation> aggs;
    @Nullable
    private final Integer buffer;
    @Nullable
    private final Boolean exactBounds;
    @Nullable
    private final Integer extent;
    private final String field;
    private final List<String> fields;
    @Nullable
    private final GridAggregationType gridAgg;
    @Nullable
    private final Integer gridPrecision;
    @Nullable
    private final GridType gridType;
    private final List<String> index;
    @Nullable
    private final String projectRouting;
    @Nullable
    private final Query query;
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final Integer size;
    private final List<SortOptions> sort;
    @Nullable
    private final TrackHits trackTotalHits;
    @Nullable
    private final Boolean withLabels;
    private final int x;
    private final int y;
    private final int zoom;
    public static final JsonpDeserializer<SearchMvtRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchMvtRequest::setupSearchMvtRequestDeserializer);
    public static final Endpoint<SearchMvtRequest, BinaryResponse, ErrorResponse> _ENDPOINT = new BinaryEndpoint<SearchMvtRequest>("es/search_mvt", request -> "POST", request -> {
        boolean _field = true;
        int _x = 2;
        int _index = 4;
        int _y = 8;
        int _zoom = 16;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        propsSet |= 4;
        propsSet |= 8;
        if ((propsSet |= 0x10) == 31) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mvt");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.field, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(String.valueOf(request.zoom), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(String.valueOf(request.x), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(String.valueOf(request.y), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _field = true;
        int _x = 2;
        int _index = 4;
        int _y = 8;
        int _zoom = 16;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        propsSet |= 4;
        propsSet |= 8;
        if ((propsSet |= 0x10) == 31) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
            params.put("field", request.field);
            params.put("zoom", String.valueOf(request.zoom));
            params.put("x", String.valueOf(request.x));
            params.put("y", String.valueOf(request.y));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.projectRouting != null) {
            params.put("project_routing", request.projectRouting);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    private SearchMvtRequest(Builder builder) {
        this.aggs = ApiTypeHelper.unmodifiable(builder.aggs);
        this.buffer = builder.buffer;
        this.exactBounds = builder.exactBounds;
        this.extent = builder.extent;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.gridAgg = builder.gridAgg;
        this.gridPrecision = builder.gridPrecision;
        this.gridType = builder.gridType;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.projectRouting = builder.projectRouting;
        this.query = builder.query;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.trackTotalHits = builder.trackTotalHits;
        this.withLabels = builder.withLabels;
        this.x = ApiTypeHelper.requireNonNull(builder.x, (Object)this, "x", 0);
        this.y = ApiTypeHelper.requireNonNull(builder.y, (Object)this, "y", 0);
        this.zoom = ApiTypeHelper.requireNonNull(builder.zoom, (Object)this, "zoom", 0);
    }

    public static SearchMvtRequest of(Function<Builder, ObjectBuilder<SearchMvtRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggs() {
        return this.aggs;
    }

    @Nullable
    public final Integer buffer() {
        return this.buffer;
    }

    @Nullable
    public final Boolean exactBounds() {
        return this.exactBounds;
    }

    @Nullable
    public final Integer extent() {
        return this.extent;
    }

    public final String field() {
        return this.field;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final GridAggregationType gridAgg() {
        return this.gridAgg;
    }

    @Nullable
    public final Integer gridPrecision() {
        return this.gridPrecision;
    }

    @Nullable
    public final GridType gridType() {
        return this.gridType;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final String projectRouting() {
        return this.projectRouting;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Nullable
    public final TrackHits trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public final Boolean withLabels() {
        return this.withLabels;
    }

    public final int x() {
        return this.x;
    }

    public final int y() {
        return this.y;
    }

    public final int zoom() {
        return this.zoom;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggs)) {
            generator.writeKey("aggs");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggs.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.buffer != null) {
            generator.writeKey("buffer");
            generator.write(this.buffer.intValue());
        }
        if (this.exactBounds != null) {
            generator.writeKey("exact_bounds");
            generator.write(this.exactBounds.booleanValue());
        }
        if (this.extent != null) {
            generator.writeKey("extent");
            generator.write(this.extent.intValue());
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.gridAgg != null) {
            generator.writeKey("grid_agg");
            this.gridAgg.serialize(generator, mapper);
        }
        if (this.gridPrecision != null) {
            generator.writeKey("grid_precision");
            generator.write(this.gridPrecision.intValue());
        }
        if (this.gridType != null) {
            generator.writeKey("grid_type");
            this.gridType.serialize(generator, mapper);
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.trackTotalHits != null) {
            generator.writeKey("track_total_hits");
            this.trackTotalHits.serialize(generator, mapper);
        }
        if (this.withLabels != null) {
            generator.writeKey("with_labels");
            generator.write(this.withLabels.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSearchMvtRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggs, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggs");
        op.add(Builder::buffer, JsonpDeserializer.integerDeserializer(), "buffer");
        op.add(Builder::exactBounds, JsonpDeserializer.booleanDeserializer(), "exact_bounds");
        op.add(Builder::extent, JsonpDeserializer.integerDeserializer(), "extent");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::gridAgg, GridAggregationType._DESERIALIZER, "grid_agg");
        op.add(Builder::gridPrecision, JsonpDeserializer.integerDeserializer(), "grid_precision");
        op.add(Builder::gridType, GridType._DESERIALIZER, "grid_type");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
        op.add(Builder::trackTotalHits, TrackHits._DESERIALIZER, "track_total_hits");
        op.add(Builder::withLabels, JsonpDeserializer.booleanDeserializer(), "with_labels");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SearchMvtRequest> {
        @Nullable
        private Map<String, Aggregation> aggs;
        @Nullable
        private Integer buffer;
        @Nullable
        private Boolean exactBounds;
        @Nullable
        private Integer extent;
        private String field;
        @Nullable
        private List<String> fields;
        @Nullable
        private GridAggregationType gridAgg;
        @Nullable
        private Integer gridPrecision;
        @Nullable
        private GridType gridType;
        private List<String> index;
        @Nullable
        private String projectRouting;
        @Nullable
        private Query query;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Integer size;
        @Nullable
        private List<SortOptions> sort;
        @Nullable
        private TrackHits trackTotalHits;
        @Nullable
        private Boolean withLabels;
        private Integer x;
        private Integer y;
        private Integer zoom;

        public Builder() {
        }

        private Builder(SearchMvtRequest instance) {
            this.aggs = instance.aggs;
            this.buffer = instance.buffer;
            this.exactBounds = instance.exactBounds;
            this.extent = instance.extent;
            this.field = instance.field;
            this.fields = instance.fields;
            this.gridAgg = instance.gridAgg;
            this.gridPrecision = instance.gridPrecision;
            this.gridType = instance.gridType;
            this.index = instance.index;
            this.projectRouting = instance.projectRouting;
            this.query = instance.query;
            this.runtimeMappings = instance.runtimeMappings;
            this.size = instance.size;
            this.sort = instance.sort;
            this.trackTotalHits = instance.trackTotalHits;
            this.withLabels = instance.withLabels;
            this.x = instance.x;
            this.y = instance.y;
            this.zoom = instance.zoom;
        }

        public final Builder aggs(Map<String, Aggregation> map) {
            this.aggs = Builder._mapPutAll(this.aggs, map);
            return this;
        }

        public final Builder aggs(String key, Aggregation value) {
            this.aggs = Builder._mapPut(this.aggs, key, value);
            return this;
        }

        public final Builder aggs(String key, AggregationVariant value) {
            this.aggs = Builder._mapPut(this.aggs, key, value._toAggregation());
            return this;
        }

        public final Builder aggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggs(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder buffer(@Nullable Integer value) {
            this.buffer = value;
            return this;
        }

        public final Builder exactBounds(@Nullable Boolean value) {
            this.exactBounds = value;
            return this;
        }

        public final Builder extent(@Nullable Integer value) {
            this.extent = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder gridAgg(@Nullable GridAggregationType value) {
            this.gridAgg = value;
            return this;
        }

        public final Builder gridPrecision(@Nullable Integer value) {
            this.gridPrecision = value;
            return this;
        }

        public final Builder gridType(@Nullable GridType value) {
            this.gridType = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder projectRouting(@Nullable String value) {
            this.projectRouting = value;
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        public final Builder trackTotalHits(@Nullable TrackHits value) {
            this.trackTotalHits = value;
            return this;
        }

        public final Builder trackTotalHits(Function<TrackHits.Builder, ObjectBuilder<TrackHits>> fn) {
            return this.trackTotalHits(fn.apply(new TrackHits.Builder()).build());
        }

        public final Builder withLabels(@Nullable Boolean value) {
            this.withLabels = value;
            return this;
        }

        public final Builder x(int value) {
            this.x = value;
            return this;
        }

        public final Builder y(int value) {
            this.y = value;
            return this;
        }

        public final Builder zoom(int value) {
            this.zoom = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchMvtRequest build() {
            this._checkSingleUse();
            return new SearchMvtRequest(this);
        }
    }
}

