/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.ExtendedSearchUsage;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class SearchUsageStats
implements JsonpSerializable {
    private final long total;
    private final Map<String, Long> queries;
    private final Map<String, Long> rescorers;
    private final Map<String, Long> sections;
    private final Map<String, Long> retrievers;
    private final ExtendedSearchUsage extended;
    public static final JsonpDeserializer<SearchUsageStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchUsageStats::setupSearchUsageStatsDeserializer);

    private SearchUsageStats(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
        this.queries = ApiTypeHelper.unmodifiableRequired(builder.queries, (Object)this, "queries");
        this.rescorers = ApiTypeHelper.unmodifiableRequired(builder.rescorers, (Object)this, "rescorers");
        this.sections = ApiTypeHelper.unmodifiableRequired(builder.sections, (Object)this, "sections");
        this.retrievers = ApiTypeHelper.unmodifiableRequired(builder.retrievers, (Object)this, "retrievers");
        this.extended = ApiTypeHelper.requireNonNull(builder.extended, this, "extended");
    }

    public static SearchUsageStats of(Function<Builder, ObjectBuilder<SearchUsageStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long total() {
        return this.total;
    }

    public final Map<String, Long> queries() {
        return this.queries;
    }

    public final Map<String, Long> rescorers() {
        return this.rescorers;
    }

    public final Map<String, Long> sections() {
        return this.sections;
    }

    public final Map<String, Long> retrievers() {
        return this.retrievers;
    }

    public final ExtendedSearchUsage extended() {
        return this.extended;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        if (ApiTypeHelper.isDefined(this.queries)) {
            generator.writeKey("queries");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.queries.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.rescorers)) {
            generator.writeKey("rescorers");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.rescorers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.sections)) {
            generator.writeKey("sections");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.sections.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.retrievers)) {
            generator.writeKey("retrievers");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.retrievers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("extended");
        this.extended.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSearchUsageStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::queries, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "queries");
        op.add(Builder::rescorers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "rescorers");
        op.add(Builder::sections, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "sections");
        op.add(Builder::retrievers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "retrievers");
        op.add(Builder::extended, ExtendedSearchUsage._DESERIALIZER, "extended");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SearchUsageStats> {
        private Long total;
        private Map<String, Long> queries;
        private Map<String, Long> rescorers;
        private Map<String, Long> sections;
        private Map<String, Long> retrievers;
        private ExtendedSearchUsage extended;

        public Builder() {
        }

        private Builder(SearchUsageStats instance) {
            this.total = instance.total;
            this.queries = instance.queries;
            this.rescorers = instance.rescorers;
            this.sections = instance.sections;
            this.retrievers = instance.retrievers;
            this.extended = instance.extended;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder queries(Map<String, Long> map) {
            this.queries = Builder._mapPutAll(this.queries, map);
            return this;
        }

        public final Builder queries(String key, Long value) {
            this.queries = Builder._mapPut(this.queries, key, value);
            return this;
        }

        public final Builder rescorers(Map<String, Long> map) {
            this.rescorers = Builder._mapPutAll(this.rescorers, map);
            return this;
        }

        public final Builder rescorers(String key, Long value) {
            this.rescorers = Builder._mapPut(this.rescorers, key, value);
            return this;
        }

        public final Builder sections(Map<String, Long> map) {
            this.sections = Builder._mapPutAll(this.sections, map);
            return this;
        }

        public final Builder sections(String key, Long value) {
            this.sections = Builder._mapPut(this.sections, key, value);
            return this;
        }

        public final Builder retrievers(Map<String, Long> map) {
            this.retrievers = Builder._mapPutAll(this.retrievers, map);
            return this;
        }

        public final Builder retrievers(String key, Long value) {
            this.retrievers = Builder._mapPut(this.retrievers, key, value);
            return this;
        }

        public final Builder extended(ExtendedSearchUsage value) {
            this.extended = value;
            return this;
        }

        public final Builder extended(Function<ExtendedSearchUsage.Builder, ObjectBuilder<ExtendedSearchUsage>> fn) {
            return this.extended(fn.apply(new ExtendedSearchUsage.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchUsageStats build() {
            this._checkSingleUse();
            return new SearchUsageStats(this);
        }
    }
}

