/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.PerRepositoryStats;
import co.elastic.clients.elasticsearch.cluster.stats.SnapshotCurrentCounts;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterSnapshotStats
implements JsonpSerializable {
    private final SnapshotCurrentCounts currentCounts;
    private final Map<String, PerRepositoryStats> repositories;
    public static final JsonpDeserializer<ClusterSnapshotStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterSnapshotStats::setupClusterSnapshotStatsDeserializer);

    private ClusterSnapshotStats(Builder builder) {
        this.currentCounts = ApiTypeHelper.requireNonNull(builder.currentCounts, this, "currentCounts");
        this.repositories = ApiTypeHelper.unmodifiableRequired(builder.repositories, (Object)this, "repositories");
    }

    public static ClusterSnapshotStats of(Function<Builder, ObjectBuilder<ClusterSnapshotStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final SnapshotCurrentCounts currentCounts() {
        return this.currentCounts;
    }

    public final Map<String, PerRepositoryStats> repositories() {
        return this.repositories;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_counts");
        this.currentCounts.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.repositories)) {
            generator.writeKey("repositories");
            generator.writeStartObject();
            for (Map.Entry<String, PerRepositoryStats> item0 : this.repositories.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupClusterSnapshotStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentCounts, SnapshotCurrentCounts._DESERIALIZER, "current_counts");
        op.add(Builder::repositories, JsonpDeserializer.stringMapDeserializer(PerRepositoryStats._DESERIALIZER), "repositories");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterSnapshotStats> {
        private SnapshotCurrentCounts currentCounts;
        private Map<String, PerRepositoryStats> repositories;

        public Builder() {
        }

        private Builder(ClusterSnapshotStats instance) {
            this.currentCounts = instance.currentCounts;
            this.repositories = instance.repositories;
        }

        public final Builder currentCounts(SnapshotCurrentCounts value) {
            this.currentCounts = value;
            return this;
        }

        public final Builder currentCounts(Function<SnapshotCurrentCounts.Builder, ObjectBuilder<SnapshotCurrentCounts>> fn) {
            return this.currentCounts(fn.apply(new SnapshotCurrentCounts.Builder()).build());
        }

        public final Builder repositories(Map<String, PerRepositoryStats> map) {
            this.repositories = Builder._mapPutAll(this.repositories, map);
            return this;
        }

        public final Builder repositories(String key, PerRepositoryStats value) {
            this.repositories = Builder._mapPut(this.repositories, key, value);
            return this;
        }

        public final Builder repositories(String key, Function<PerRepositoryStats.Builder, ObjectBuilder<PerRepositoryStats>> fn) {
            return this.repositories(key, fn.apply(new PerRepositoryStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterSnapshotStats build() {
            this._checkSingleUse();
            return new ClusterSnapshotStats(this);
        }
    }
}

