/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterOperatingSystemArchitecture
implements JsonpSerializable {
    private final String arch;
    private final int count;
    public static final JsonpDeserializer<ClusterOperatingSystemArchitecture> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterOperatingSystemArchitecture::setupClusterOperatingSystemArchitectureDeserializer);

    private ClusterOperatingSystemArchitecture(Builder builder) {
        this.arch = ApiTypeHelper.requireNonNull(builder.arch, this, "arch");
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
    }

    public static ClusterOperatingSystemArchitecture of(Function<Builder, ObjectBuilder<ClusterOperatingSystemArchitecture>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String arch() {
        return this.arch;
    }

    public final int count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("arch");
        generator.write(this.arch);
        generator.writeKey("count");
        generator.write(this.count);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupClusterOperatingSystemArchitectureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::arch, JsonpDeserializer.stringDeserializer(), "arch");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterOperatingSystemArchitecture> {
        private String arch;
        private Integer count;

        public Builder() {
        }

        private Builder(ClusterOperatingSystemArchitecture instance) {
            this.arch = instance.arch;
            this.count = instance.count;
        }

        public final Builder arch(String value) {
            this.arch = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterOperatingSystemArchitecture build() {
            this._checkSingleUse();
            return new ClusterOperatingSystemArchitecture(this);
        }
    }
}

