/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WhitespaceTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    @Nullable
    private final Integer maxTokenLength;
    public static final JsonpDeserializer<WhitespaceTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WhitespaceTokenizer::setupWhitespaceTokenizerDeserializer);

    private WhitespaceTokenizer(Builder builder) {
        super(builder);
        this.maxTokenLength = builder.maxTokenLength;
    }

    public static WhitespaceTokenizer of(Function<Builder, ObjectBuilder<WhitespaceTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.Whitespace;
    }

    @Nullable
    public final Integer maxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "whitespace");
        super.serializeInternal(generator, mapper);
        if (this.maxTokenLength != null) {
            generator.writeKey("max_token_length");
            generator.write(this.maxTokenLength.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupWhitespaceTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::maxTokenLength, JsonpDeserializer.integerDeserializer(), "max_token_length");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WhitespaceTokenizer> {
        @Nullable
        private Integer maxTokenLength;

        public Builder() {
        }

        private Builder(WhitespaceTokenizer instance) {
            this.maxTokenLength = instance.maxTokenLength;
        }

        public final Builder maxTokenLength(@Nullable Integer value) {
            this.maxTokenLength = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WhitespaceTokenizer build() {
            this._checkSingleUse();
            return new WhitespaceTokenizer(this);
        }
    }
}

