/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.CharFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.CharFilterDefinitionVariant;
import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationMode;
import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IcuNormalizationCharFilter
extends CharFilterBase
implements CharFilterDefinitionVariant {
    @Nullable
    private final IcuNormalizationMode mode;
    @Nullable
    private final IcuNormalizationType name;
    @Nullable
    private final String unicodeSetFilter;
    public static final JsonpDeserializer<IcuNormalizationCharFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuNormalizationCharFilter::setupIcuNormalizationCharFilterDeserializer);

    private IcuNormalizationCharFilter(Builder builder) {
        super(builder);
        this.mode = builder.mode;
        this.name = builder.name;
        this.unicodeSetFilter = builder.unicodeSetFilter;
    }

    public static IcuNormalizationCharFilter of(Function<Builder, ObjectBuilder<IcuNormalizationCharFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public CharFilterDefinition.Kind _charFilterDefinitionKind() {
        return CharFilterDefinition.Kind.IcuNormalizer;
    }

    @Nullable
    public final IcuNormalizationMode mode() {
        return this.mode;
    }

    @Nullable
    public final IcuNormalizationType name() {
        return this.name;
    }

    @Nullable
    public final String unicodeSetFilter() {
        return this.unicodeSetFilter;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_normalizer");
        super.serializeInternal(generator, mapper);
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (this.name != null) {
            generator.writeKey("name");
            this.name.serialize(generator, mapper);
        }
        if (this.unicodeSetFilter != null) {
            generator.writeKey("unicode_set_filter");
            generator.write(this.unicodeSetFilter);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIcuNormalizationCharFilterDeserializer(ObjectDeserializer<Builder> op) {
        CharFilterBase.setupCharFilterBaseDeserializer(op);
        op.add(Builder::mode, IcuNormalizationMode._DESERIALIZER, "mode");
        op.add(Builder::name, IcuNormalizationType._DESERIALIZER, "name");
        op.add(Builder::unicodeSetFilter, JsonpDeserializer.stringDeserializer(), "unicode_set_filter");
        op.ignore("type");
    }

    public static class Builder
    extends CharFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuNormalizationCharFilter> {
        @Nullable
        private IcuNormalizationMode mode;
        @Nullable
        private IcuNormalizationType name;
        @Nullable
        private String unicodeSetFilter;

        public Builder() {
        }

        private Builder(IcuNormalizationCharFilter instance) {
            this.mode = instance.mode;
            this.name = instance.name;
            this.unicodeSetFilter = instance.unicodeSetFilter;
        }

        public final Builder mode(@Nullable IcuNormalizationMode value) {
            this.mode = value;
            return this;
        }

        public final Builder name(@Nullable IcuNormalizationType value) {
            this.name = value;
            return this;
        }

        public final Builder unicodeSetFilter(@Nullable String value) {
            this.unicodeSetFilter = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuNormalizationCharFilter build() {
            this._checkSingleUse();
            return new IcuNormalizationCharFilter(this);
        }
    }
}

