/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StandardDeviationBounds
implements JsonpSerializable {
    @Nullable
    private final Double upper;
    @Nullable
    private final Double lower;
    @Nullable
    private final Double upperPopulation;
    @Nullable
    private final Double lowerPopulation;
    @Nullable
    private final Double upperSampling;
    @Nullable
    private final Double lowerSampling;
    public static final JsonpDeserializer<StandardDeviationBounds> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StandardDeviationBounds::setupStandardDeviationBoundsDeserializer);

    private StandardDeviationBounds(Builder builder) {
        this.upper = builder.upper;
        this.lower = builder.lower;
        this.upperPopulation = builder.upperPopulation;
        this.lowerPopulation = builder.lowerPopulation;
        this.upperSampling = builder.upperSampling;
        this.lowerSampling = builder.lowerSampling;
    }

    public static StandardDeviationBounds of(Function<Builder, ObjectBuilder<StandardDeviationBounds>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double upper() {
        return this.upper;
    }

    @Nullable
    public final Double lower() {
        return this.lower;
    }

    @Nullable
    public final Double upperPopulation() {
        return this.upperPopulation;
    }

    @Nullable
    public final Double lowerPopulation() {
        return this.lowerPopulation;
    }

    @Nullable
    public final Double upperSampling() {
        return this.upperSampling;
    }

    @Nullable
    public final Double lowerSampling() {
        return this.lowerSampling;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.upper != null) {
            generator.writeKey("upper");
            generator.write(this.upper.doubleValue());
        }
        if (this.lower != null) {
            generator.writeKey("lower");
            generator.write(this.lower.doubleValue());
        }
        if (this.upperPopulation != null) {
            generator.writeKey("upper_population");
            generator.write(this.upperPopulation.doubleValue());
        }
        if (this.lowerPopulation != null) {
            generator.writeKey("lower_population");
            generator.write(this.lowerPopulation.doubleValue());
        }
        if (this.upperSampling != null) {
            generator.writeKey("upper_sampling");
            generator.write(this.upperSampling.doubleValue());
        }
        if (this.lowerSampling != null) {
            generator.writeKey("lower_sampling");
            generator.write(this.lowerSampling.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupStandardDeviationBoundsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::upper, JsonpDeserializer.doubleDeserializer(), "upper");
        op.add(Builder::lower, JsonpDeserializer.doubleDeserializer(), "lower");
        op.add(Builder::upperPopulation, JsonpDeserializer.doubleDeserializer(), "upper_population");
        op.add(Builder::lowerPopulation, JsonpDeserializer.doubleDeserializer(), "lower_population");
        op.add(Builder::upperSampling, JsonpDeserializer.doubleDeserializer(), "upper_sampling");
        op.add(Builder::lowerSampling, JsonpDeserializer.doubleDeserializer(), "lower_sampling");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<StandardDeviationBounds> {
        @Nullable
        private Double upper;
        @Nullable
        private Double lower;
        @Nullable
        private Double upperPopulation;
        @Nullable
        private Double lowerPopulation;
        @Nullable
        private Double upperSampling;
        @Nullable
        private Double lowerSampling;

        public Builder() {
        }

        private Builder(StandardDeviationBounds instance) {
            this.upper = instance.upper;
            this.lower = instance.lower;
            this.upperPopulation = instance.upperPopulation;
            this.lowerPopulation = instance.lowerPopulation;
            this.upperSampling = instance.upperSampling;
            this.lowerSampling = instance.lowerSampling;
        }

        public final Builder upper(@Nullable Double value) {
            this.upper = value;
            return this;
        }

        public final Builder lower(@Nullable Double value) {
            this.lower = value;
            return this;
        }

        public final Builder upperPopulation(@Nullable Double value) {
            this.upperPopulation = value;
            return this;
        }

        public final Builder lowerPopulation(@Nullable Double value) {
            this.lowerPopulation = value;
            return this;
        }

        public final Builder upperSampling(@Nullable Double value) {
            this.upperSampling = value;
            return this;
        }

        public final Builder lowerSampling(@Nullable Double value) {
            this.lowerSampling = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StandardDeviationBounds build() {
            this._checkSingleUse();
            return new StandardDeviationBounds(this);
        }
    }
}

