/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.SortMode;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MatrixAggregation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MatrixStatsAggregation
extends MatrixAggregation
implements AggregationVariant {
    @Nullable
    private final SortMode mode;
    public static final JsonpDeserializer<MatrixStatsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatrixStatsAggregation::setupMatrixStatsAggregationDeserializer);

    private MatrixStatsAggregation(Builder builder) {
        super(builder);
        this.mode = builder.mode;
    }

    public static MatrixStatsAggregation of(Function<Builder, ObjectBuilder<MatrixStatsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MatrixStats;
    }

    @Nullable
    public final SortMode mode() {
        return this.mode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMatrixStatsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MatrixAggregation.setupMatrixAggregationDeserializer(op);
        op.add(Builder::mode, SortMode._DESERIALIZER, "mode");
    }

    public static class Builder
    extends MatrixAggregation.AbstractBuilder<Builder>
    implements ObjectBuilder<MatrixStatsAggregation> {
        @Nullable
        private SortMode mode;

        public Builder() {
        }

        private Builder(MatrixStatsAggregation instance) {
            this.mode = instance.mode;
        }

        public final Builder mode(@Nullable SortMode value) {
            this.mode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MatrixStatsAggregation build() {
            this._checkSingleUse();
            return new MatrixStatsAggregation(this);
        }
    }
}

