/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IpRangeBucket
extends MultiBucketBase {
    @Nullable
    private final String key;
    @Nullable
    private final String from;
    @Nullable
    private final String to;
    public static final JsonpDeserializer<IpRangeBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpRangeBucket::setupIpRangeBucketDeserializer);

    private IpRangeBucket(Builder builder) {
        super(builder);
        this.key = builder.key;
        this.from = builder.from;
        this.to = builder.to;
    }

    public static IpRangeBucket of(Function<Builder, ObjectBuilder<IpRangeBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String key() {
        return this.key;
    }

    @Nullable
    public final String from() {
        return this.from;
    }

    @Nullable
    public final String to() {
        return this.to;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.key != null) {
            generator.writeKey("key");
            generator.write(this.key);
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from);
        }
        if (this.to != null) {
            generator.writeKey("to");
            generator.write(this.to);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIpRangeBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
        op.add(Builder::from, JsonpDeserializer.stringDeserializer(), "from");
        op.add(Builder::to, JsonpDeserializer.stringDeserializer(), "to");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IpRangeBucket> {
        @Nullable
        private String key;
        @Nullable
        private String from;
        @Nullable
        private String to;

        public Builder() {
        }

        private Builder(IpRangeBucket instance) {
            this.key = instance.key;
            this.from = instance.from;
            this.to = instance.to;
        }

        public final Builder key(@Nullable String value) {
            this.key = value;
            return this;
        }

        public final Builder from(@Nullable String value) {
            this.from = value;
            return this;
        }

        public final Builder to(@Nullable String value) {
            this.to = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IpRangeBucket build() {
            this._checkSingleUse();
            return new IpRangeBucket(this);
        }
    }
}

