/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketCorrelationFunction;
import co.elastic.clients.elasticsearch._types.aggregations.BucketPathAggregation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class BucketCorrelationAggregation
extends BucketPathAggregation
implements AggregationVariant {
    private final BucketCorrelationFunction function;
    public static final JsonpDeserializer<BucketCorrelationAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketCorrelationAggregation::setupBucketCorrelationAggregationDeserializer);

    private BucketCorrelationAggregation(Builder builder) {
        super(builder);
        this.function = ApiTypeHelper.requireNonNull(builder.function, this, "function");
    }

    public static BucketCorrelationAggregation of(Function<Builder, ObjectBuilder<BucketCorrelationAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.BucketCorrelation;
    }

    public final BucketCorrelationFunction function() {
        return this.function;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("function");
        this.function.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupBucketCorrelationAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketPathAggregation.setupBucketPathAggregationDeserializer(op);
        op.add(Builder::function, BucketCorrelationFunction._DESERIALIZER, "function");
    }

    public static class Builder
    extends BucketPathAggregation.AbstractBuilder<Builder>
    implements ObjectBuilder<BucketCorrelationAggregation> {
        private BucketCorrelationFunction function;

        public Builder() {
        }

        private Builder(BucketCorrelationAggregation instance) {
            this.function = instance.function;
        }

        public final Builder function(BucketCorrelationFunction value) {
            this.function = value;
            return this;
        }

        public final Builder function(Function<BucketCorrelationFunction.Builder, ObjectBuilder<BucketCorrelationFunction>> fn) {
            return this.function(fn.apply(new BucketCorrelationFunction.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketCorrelationAggregation build() {
            this._checkSingleUse();
            return new BucketCorrelationAggregation(this);
        }
    }
}

