/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeAttributes
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final String ephemeralId;
    @Nullable
    private final String id;
    private final String name;
    private final String transportAddress;
    public static final JsonpDeserializer<NodeAttributes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeAttributes::setupNodeAttributesDeserializer);

    private NodeAttributes(Builder builder) {
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.ephemeralId = ApiTypeHelper.requireNonNull(builder.ephemeralId, this, "ephemeralId");
        this.id = builder.id;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
    }

    public static NodeAttributes of(Function<Builder, ObjectBuilder<NodeAttributes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String ephemeralId() {
        return this.ephemeralId;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.attributes.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("ephemeral_id");
        generator.write(this.ephemeralId);
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNodeAttributesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::ephemeralId, JsonpDeserializer.stringDeserializer(), "ephemeral_id");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeAttributes> {
        private Map<String, String> attributes;
        private String ephemeralId;
        @Nullable
        private String id;
        private String name;
        private String transportAddress;

        public Builder() {
        }

        private Builder(NodeAttributes instance) {
            this.attributes = instance.attributes;
            this.ephemeralId = instance.ephemeralId;
            this.id = instance.id;
            this.name = instance.name;
            this.transportAddress = instance.transportAddress;
        }

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder ephemeralId(String value) {
            this.ephemeralId = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeAttributes build() {
            this._checkSingleUse();
            return new NodeAttributes(this);
        }
    }
}

