/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CartesianPoint
implements JsonpSerializable {
    private final double x;
    private final double y;
    public static final JsonpDeserializer<CartesianPoint> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CartesianPoint::setupCartesianPointDeserializer);

    private CartesianPoint(Builder builder) {
        this.x = ApiTypeHelper.requireNonNull(builder.x, (Object)this, "x", 0.0);
        this.y = ApiTypeHelper.requireNonNull(builder.y, (Object)this, "y", 0.0);
    }

    public static CartesianPoint of(Function<Builder, ObjectBuilder<CartesianPoint>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("x");
        generator.write(this.x);
        generator.writeKey("y");
        generator.write(this.y);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCartesianPointDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::x, JsonpDeserializer.doubleDeserializer(), "x");
        op.add(Builder::y, JsonpDeserializer.doubleDeserializer(), "y");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CartesianPoint> {
        private Double x;
        private Double y;

        public Builder() {
        }

        private Builder(CartesianPoint instance) {
            this.x = instance.x;
            this.y = instance.y;
        }

        public final Builder x(double value) {
            this.x = value;
            return this;
        }

        public final Builder y(double value) {
            this.y = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CartesianPoint build() {
            this._checkSingleUse();
            return new CartesianPoint(this);
        }
    }
}

