/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportException;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.Version;
import co.elastic.clients.transport.endpoints.BinaryDataResponse;
import co.elastic.clients.transport.endpoints.BinaryEndpoint;
import co.elastic.clients.transport.endpoints.BooleanEndpoint;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.http.HeaderMap;
import co.elastic.clients.transport.http.RepeatableBodyResponse;
import co.elastic.clients.transport.http.TransportHttpClient;
import co.elastic.clients.transport.instrumentation.Instrumentation;
import co.elastic.clients.transport.instrumentation.NoopInstrumentation;
import co.elastic.clients.transport.instrumentation.OpenTelemetryForElasticsearch;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.BinaryData;
import co.elastic.clients.util.ByteArrayBinaryData;
import co.elastic.clients.util.LanguageRuntimeVersions;
import co.elastic.clients.util.MissingRequiredPropertyException;
import co.elastic.clients.util.NoCopyByteArrayOutputStream;
import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public abstract class ElasticsearchTransportBase
implements ElasticsearchTransport {
    private static final String USER_AGENT_VALUE = ElasticsearchTransportBase.getUserAgent();
    private static final String CLIENT_META_VALUE = ElasticsearchTransportBase.getClientMeta();
    public static final String JSON_CONTENT_TYPE = Version.VERSION == null ? "application/json" : "application/vnd.elasticsearch+json; compatible-with=" + Version.VERSION.major();
    protected final TransportHttpClient httpClient;
    protected final Instrumentation instrumentation;
    protected final JsonpMapper mapper;
    protected final TransportOptions transportOptions;
    private static final HeaderMap JsonContentTypeHeaders = new HeaderMap();
    private static final HeaderMap DefaultHeaders = new HeaderMap();
    private static final ByteBuffer NdJsonSeparator;
    private static final Set<String> endpointsMissingProductHeader;

    public ElasticsearchTransportBase(TransportHttpClient httpClient, TransportOptions options, JsonpMapper jsonpMapper) {
        this(httpClient, options, jsonpMapper, null);
    }

    public ElasticsearchTransportBase(TransportHttpClient httpClient, TransportOptions options, JsonpMapper jsonpMapper, @Nullable Instrumentation instrumentation) {
        this.mapper = jsonpMapper;
        this.httpClient = httpClient;
        this.transportOptions = httpClient.createOptions(options);
        if (instrumentation == null) {
            instrumentation = OpenTelemetryForElasticsearch.getDefault();
        }
        if (instrumentation == null) {
            instrumentation = NoopInstrumentation.INSTANCE;
        }
        this.instrumentation = instrumentation;
    }

    protected ElasticsearchTransportBase cloneWith(@Nullable TransportOptions options, @Nullable JsonpMapper mapper, @Nullable Instrumentation instrumentation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Override
    public final JsonpMapper jsonpMapper() {
        return this.mapper;
    }

    @Override
    public final TransportOptions options() {
        return this.transportOptions;
    }

    public TransportHttpClient httpClient() {
        return this.httpClient;
    }

    /*
     * Loose catch block
     */
    @Override
    public final <RequestT, ResponseT, ErrorT> ResponseT performRequest(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint, @Nullable TransportOptions options) throws IOException {
        ResponseT ResponseT;
        Instrumentation.ThreadScope ts;
        Instrumentation.Context ctx;
        block14: {
            ctx = this.instrumentation.newContext(request, endpoint);
            ts = ctx.makeCurrent();
            TransportOptions opts = options == null ? this.transportOptions : options;
            TransportHttpClient.Request req = this.prepareTransportRequest(request, endpoint);
            ctx.beforeSendingHttpRequest(req, options);
            TransportHttpClient.Response resp = this.httpClient.performRequest(endpoint.id(), null, req, opts);
            ctx.afterReceivingHttpResponse(resp);
            ResponseT apiResponse = this.getApiResponse(resp, endpoint);
            ctx.afterDecodingApiResponse(apiResponse);
            ResponseT = apiResponse;
            if (ts != null) {
                ts.close();
            }
            if (ctx == null) break block14;
            ctx.close();
        }
        return ResponseT;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ts != null) {
                            try {
                                ts.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        ctx.recordException(throwable3);
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable4.addSuppressed(throwable5);
                        }
                    }
                    throw throwable4;
                }
            }
        }
    }

    @Override
    public final <RequestT, ResponseT, ErrorT> CompletableFuture<ResponseT> performRequestAsync(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint, @Nullable TransportOptions options) {
        TransportHttpClient.Request clientReq;
        Instrumentation.Context ctx = this.instrumentation.newContext(request, endpoint);
        TransportOptions opts = options == null ? this.transportOptions : options;
        try (Instrumentation.ThreadScope ss = ctx.makeCurrent();){
            clientReq = this.prepareTransportRequest(request, endpoint);
            ctx.beforeSendingHttpRequest(clientReq, options);
        }
        catch (Exception e) {
            ctx.recordException(e);
            ctx.close();
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(e);
            return future;
        }
        boolean disableRequiredChecks = ApiTypeHelper.requiredPropertiesCheckDisabled();
        final CompletableFuture<TransportHttpClient.Response> clientFuture = this.httpClient.performRequestAsync(endpoint.id(), null, clientReq, opts);
        CompletableFuture future = new CompletableFuture<ResponseT>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelled = super.cancel(mayInterruptIfRunning);
                if (cancelled) {
                    clientFuture.cancel(mayInterruptIfRunning);
                }
                return cancelled;
            }
        };
        clientFuture.handle((clientResp, thr) -> {
            block18: {
                try (Instrumentation.ThreadScope ts = ctx.makeCurrent();){
                    if (thr != null) {
                        ctx.recordException((Throwable)thr);
                        ctx.close();
                        future.completeExceptionally((Throwable)thr);
                        break block18;
                    }
                    try {
                        try (ApiTypeHelper.DisabledChecksHandle h = ApiTypeHelper.DANGEROUS_disableRequiredPropertiesCheck(disableRequiredChecks);){
                            ctx.afterReceivingHttpResponse((TransportHttpClient.Response)clientResp);
                            Object response = this.getApiResponse((TransportHttpClient.Response)clientResp, endpoint);
                            ctx.afterDecodingApiResponse(response);
                            future.complete(response);
                        }
                        ctx.close();
                    }
                    catch (Throwable e) {
                        try {
                            ctx.recordException(e);
                            future.completeExceptionally(e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ctx.close();
                        }
                    }
                }
            }
            return null;
        });
        return future;
    }

    private <RequestT, ResponseT, ErrorT> TransportHttpClient.Request prepareTransportRequest(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint) throws IOException {
        String method = endpoint.method(request);
        String path = endpoint.requestUrl(request);
        Map<String, String> params = endpoint.queryParameters(request);
        List<ByteBuffer> bodyBuffers = null;
        HeaderMap headers = JsonContentTypeHeaders;
        Object body = endpoint.body(request);
        if (body != null) {
            if (body instanceof NdJsonpSerializable) {
                bodyBuffers = new ArrayList<ByteBuffer>();
                this.collectNdJsonLines(bodyBuffers, (NdJsonpSerializable)request);
            } else if (body instanceof BinaryData) {
                BinaryData data = (BinaryData)body;
                String dataContentType = data.contentType();
                if (!"application/json".equals(dataContentType)) {
                    headers = new HeaderMap(DefaultHeaders);
                    headers.put("Content-Type", dataContentType);
                }
                bodyBuffers = Collections.singletonList(data.asByteBuffer());
            } else {
                NoCopyByteArrayOutputStream baos = new NoCopyByteArrayOutputStream();
                JsonGenerator generator = this.mapper.jsonProvider().createGenerator((OutputStream)baos);
                this.mapper.serialize(body, generator);
                RuntimeException closeException = null;
                try {
                    generator.close();
                }
                catch (RuntimeException e) {
                    closeException = e;
                }
                if (baos.size() > 0) {
                    if (closeException != null) {
                        throw closeException;
                    }
                    bodyBuffers = Collections.singletonList(baos.asByteBuffer());
                    headers = JsonContentTypeHeaders;
                }
            }
        }
        return new TransportHttpClient.Request(method, path, params, headers, bodyBuffers);
    }

    private void collectNdJsonLines(List<ByteBuffer> lines, NdJsonpSerializable value) throws IOException {
        Iterator<?> values = value._serializables();
        while (values.hasNext()) {
            Object item = values.next();
            if (item == null) continue;
            if (item instanceof NdJsonpSerializable && item != value) {
                this.collectNdJsonLines(lines, (NdJsonpSerializable)item);
                continue;
            }
            lines.add(BinaryData.of(item, this.mapper).asByteBuffer());
            lines.add(NdJsonSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResponseT, ErrorT> ResponseT getApiResponse(TransportHttpClient.Response clientResp, Endpoint<?, ResponseT, ErrorT> endpoint) throws IOException {
        int statusCode = clientResp.statusCode();
        if (this.options().keepResponseBodyOnException()) {
            clientResp = RepeatableBodyResponse.of(clientResp);
        }
        if (statusCode == 200) {
            this.checkProductHeader(clientResp, endpoint);
        }
        if (endpoint.isError(statusCode)) {
            JsonpDeserializer<ErrorT> errorDeserializer = endpoint.errorDeserializer(statusCode);
            if (errorDeserializer == null) {
                throw new TransportException(clientResp, "Request failed with status code '" + statusCode + "'", endpoint.id());
            }
            BinaryData entity = clientResp.body();
            if (entity == null) {
                throw new TransportException(clientResp, "Expecting a response body, but none was sent", endpoint.id());
            }
            this.checkJsonContentType(entity.contentType(), clientResp, endpoint);
            if (!entity.isRepeatable()) {
                entity = new ByteArrayBinaryData(entity);
            }
            try {
                InputStream content = entity.asInputStream();
                try {
                    JsonParser parser = this.mapper.jsonProvider().createParser(content);
                    try {
                        ErrorT error = errorDeserializer.deserialize(parser, this.mapper);
                        throw new ElasticsearchException(endpoint.id(), (ErrorResponse)error, clientResp);
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Throwable parser) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable) {
                            parser.addSuppressed(throwable);
                        }
                    }
                    throw parser;
                }
            }
            catch (MissingRequiredPropertyException | JsonException errorEx) {
                ResponseT ResponseT;
                try {
                    ResponseT response;
                    ResponseT = response = this.decodeTransportResponse(statusCode, entity, clientResp, endpoint);
                }
                catch (Exception respEx) {
                    throw new TransportException(clientResp, "Failed to decode error response, check exception cause for additional details", endpoint.id(), errorEx);
                }
                if (!(endpoint instanceof BinaryEndpoint) || endpoint.isError(statusCode)) {
                    clientResp.close();
                }
                return ResponseT;
            }
        }
        ResponseT ResponseT = this.decodeTransportResponse(statusCode, clientResp.body(), clientResp, endpoint);
        return ResponseT;
        finally {
            if (!(endpoint instanceof BinaryEndpoint) || endpoint.isError(statusCode)) {
                clientResp.close();
            }
        }
    }

    private <ResponseT> ResponseT decodeTransportResponse(int statusCode, @Nullable BinaryData entity, TransportHttpClient.Response clientResp, Endpoint<?, ResponseT, ?> endpoint) throws IOException {
        if (endpoint instanceof JsonEndpoint) {
            JsonEndpoint jsonEndpoint = (JsonEndpoint)endpoint;
            ResponseT response = null;
            JsonpDeserializer responseParser = jsonEndpoint.responseDeserializer();
            if (responseParser != null) {
                if (entity == null) {
                    throw new TransportException(clientResp, "Expecting a response body, but none was sent", endpoint.id());
                }
                this.checkJsonContentType(entity.contentType(), clientResp, endpoint);
                try (InputStream content = entity.asInputStream();
                     JsonParser parser = this.mapper.jsonProvider().createParser(content);){
                    response = responseParser.deserialize(parser, this.mapper);
                }
                catch (Exception e) {
                    throw new TransportException(clientResp, "Failed to decode response", endpoint.id(), e);
                }
            }
            return response;
        }
        if (endpoint instanceof BooleanEndpoint) {
            BooleanEndpoint bep = (BooleanEndpoint)endpoint;
            BooleanResponse response = new BooleanResponse(bep.getResult(statusCode));
            return (ResponseT)response;
        }
        if (endpoint instanceof BinaryEndpoint) {
            BinaryDataResponse response = new BinaryDataResponse(entity);
            return (ResponseT)response;
        }
        throw new TransportException(clientResp, "Unhandled endpoint type: '" + endpoint.getClass().getName() + "'", endpoint.id());
    }

    private void checkProductHeader(TransportHttpClient.Response clientResp, Endpoint<?, ?, ?> endpoint) throws IOException {
        String header = clientResp.header("X-Elastic-Product");
        if (header == null) {
            if (endpointsMissingProductHeader.contains(endpoint.id())) {
                return;
            }
            throw new TransportException(clientResp, "Missing [X-Elastic-Product] header. Please check that you are connecting to an Elasticsearch instance, and that any networking filters are preserving that header.", endpoint.id());
        }
        if (!"Elasticsearch".equals(header)) {
            throw new TransportException(clientResp, "Invalid value '" + header + "' for 'X-Elastic-Product' header.", endpoint.id());
        }
    }

    private void checkJsonContentType(String contentType, TransportHttpClient.Response clientResp, Endpoint<?, ?, ?> endpoint) throws IOException {
        if (contentType == null) {
            throw new TransportException(clientResp, "Response has no content-type", endpoint.id());
        }
        if (contentType.startsWith("application/json") || contentType.startsWith("application/vnd.elasticsearch+json")) {
            return;
        }
        throw new TransportException(clientResp, "Expecting JSON data but response content-type is: " + contentType, endpoint.id());
    }

    private static void addStandardHeaders(HeaderMap headers) {
        headers.put("User-Agent", USER_AGENT_VALUE);
        headers.put("X-Elastic-Client-Meta", CLIENT_META_VALUE);
        headers.put("Accept", JSON_CONTENT_TYPE);
    }

    private static String getUserAgent() {
        return String.format(Locale.ROOT, "elastic-java/%s (Java/%s)", Version.VERSION == null ? "Unknown" : Version.VERSION.toString(), System.getProperty("java.version"));
    }

    static String getClientMeta() {
        String flavorKey = "es=";
        String transportVersion = "9.2.2";
        return flavorKey + "9.2.2,jv=" + System.getProperty("java.specification.version") + ",t=" + transportVersion + ",hl=2" + LanguageRuntimeVersions.getRuntimeMetadata();
    }

    static {
        ElasticsearchTransportBase.addStandardHeaders(DefaultHeaders);
        ElasticsearchTransportBase.addStandardHeaders(JsonContentTypeHeaders);
        JsonContentTypeHeaders.put("Content-Type", JSON_CONTENT_TYPE);
        NdJsonSeparator = ByteBuffer.wrap("\n".getBytes(StandardCharsets.UTF_8));
        endpointsMissingProductHeader = new HashSet<String>(Arrays.asList("es/snapshot.create"));
    }
}

