/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AdjacencyMatrixAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    private final Map<String, Query> filters;
    @Nullable
    private final String separator;
    public static final JsonpDeserializer<AdjacencyMatrixAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdjacencyMatrixAggregation::setupAdjacencyMatrixAggregationDeserializer);

    private AdjacencyMatrixAggregation(Builder builder) {
        this.filters = ApiTypeHelper.unmodifiable(builder.filters);
        this.separator = builder.separator;
    }

    public static AdjacencyMatrixAggregation of(Function<Builder, ObjectBuilder<AdjacencyMatrixAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.AdjacencyMatrix;
    }

    public final Map<String, Query> filters() {
        return this.filters;
    }

    @Nullable
    public final String separator() {
        return this.separator;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.filters)) {
            generator.writeKey("filters");
            generator.writeStartObject();
            for (Map.Entry<String, Query> item0 : this.filters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.separator != null) {
            generator.writeKey("separator");
            generator.write(this.separator);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAdjacencyMatrixAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filters, JsonpDeserializer.stringMapDeserializer(Query._DESERIALIZER), "filters");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AdjacencyMatrixAggregation> {
        @Nullable
        private Map<String, Query> filters;
        @Nullable
        private String separator;

        public final Builder filters(Map<String, Query> map) {
            this.filters = Builder._mapPutAll(this.filters, map);
            return this;
        }

        public final Builder filters(String key, Query value) {
            this.filters = Builder._mapPut(this.filters, key, value);
            return this;
        }

        public final Builder filters(String key, QueryVariant value) {
            this.filters = Builder._mapPut(this.filters, key, value._toQuery());
            return this;
        }

        public final Builder filters(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filters(key, fn.apply(new Query.Builder()).build());
        }

        public final Builder separator(@Nullable String value) {
            this.separator = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AdjacencyMatrixAggregation build() {
            this._checkSingleUse();
            return new AdjacencyMatrixAggregation(this);
        }
    }
}

