/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.DeepSeekServiceSettings;
import co.elastic.clients.elasticsearch.inference.DeepSeekServiceType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutDeepseekResponse;
import co.elastic.clients.elasticsearch.inference.TaskTypeDeepSeek;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDeepseekRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String deepseekInferenceId;
    private final DeepSeekServiceType service;
    private final DeepSeekServiceSettings serviceSettings;
    private final TaskTypeDeepSeek taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutDeepseekRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDeepseekRequest::setupPutDeepseekRequestDeserializer);
    public static final Endpoint<PutDeepseekRequest, PutDeepseekResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutDeepseekRequest, PutDeepseekResponse>("es/inference.put_deepseek", request -> "PUT", request -> {
        boolean _deepseekInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.deepseekInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _deepseekInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("deepseekInferenceId", request.deepseekInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutDeepseekResponse._DESERIALIZER);

    private PutDeepseekRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.deepseekInferenceId = ApiTypeHelper.requireNonNull(builder.deepseekInferenceId, this, "deepseekInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutDeepseekRequest of(Function<Builder, ObjectBuilder<PutDeepseekRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String deepseekInferenceId() {
        return this.deepseekInferenceId;
    }

    public final DeepSeekServiceType service() {
        return this.service;
    }

    public final DeepSeekServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public final TaskTypeDeepSeek taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
    }

    protected static void setupPutDeepseekRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, DeepSeekServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, DeepSeekServiceSettings._DESERIALIZER, "service_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutDeepseekRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String deepseekInferenceId;
        private DeepSeekServiceType service;
        private DeepSeekServiceSettings serviceSettings;
        private TaskTypeDeepSeek taskType;
        @Nullable
        private Time timeout;

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder deepseekInferenceId(String value) {
            this.deepseekInferenceId = value;
            return this;
        }

        public final Builder service(DeepSeekServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(DeepSeekServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<DeepSeekServiceSettings.Builder, ObjectBuilder<DeepSeekServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new DeepSeekServiceSettings.Builder()).build());
        }

        public final Builder taskType(TaskTypeDeepSeek value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDeepseekRequest build() {
            this._checkSingleUse();
            return new PutDeepseekRequest(this);
        }
    }
}

