/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch.core.MsearchResponse;
import co.elastic.clients.elasticsearch.core.msearch.RequestItem;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MsearchRequest
extends RequestBase
implements NdJsonpSerializable,
JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeNamedQueriesScore;
    private final List<String> index;
    @Nullable
    private final Integer maxConcurrentSearches;
    @Nullable
    private final Integer maxConcurrentShardRequests;
    @Nullable
    private final Long preFilterShardSize;
    @Nullable
    private final String routing;
    @Nullable
    private final SearchType searchType;
    private final List<RequestItem> searches;
    public static final SimpleEndpoint<MsearchRequest, ?> _ENDPOINT = new SimpleEndpoint<MsearchRequest, MsearchResponse<Object>>("es/msearch", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_msearch");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_msearch");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typed_keys", "true");
        if (request.preFilterShardSize != null) {
            params.put("pre_filter_shard_size", String.valueOf(request.preFilterShardSize));
        }
        if (request.maxConcurrentShardRequests != null) {
            params.put("max_concurrent_shard_requests", String.valueOf(request.maxConcurrentShardRequests));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.includeNamedQueriesScore != null) {
            params.put("include_named_queries_score", String.valueOf(request.includeNamedQueriesScore));
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.jsonValue());
        }
        if (request.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(request.ccsMinimizeRoundtrips));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(request.ignoreThrottled));
        }
        if (request.maxConcurrentSearches != null) {
            params.put("max_concurrent_searches", String.valueOf(request.maxConcurrentSearches));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, MsearchResponse._DESERIALIZER);

    private MsearchRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeNamedQueriesScore = builder.includeNamedQueriesScore;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.maxConcurrentSearches = builder.maxConcurrentSearches;
        this.maxConcurrentShardRequests = builder.maxConcurrentShardRequests;
        this.preFilterShardSize = builder.preFilterShardSize;
        this.routing = builder.routing;
        this.searchType = builder.searchType;
        this.searches = ApiTypeHelper.unmodifiableRequired(builder.searches, (Object)this, "searches");
    }

    public static MsearchRequest of(Function<Builder, ObjectBuilder<MsearchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Iterator<?> _serializables() {
        return this.searches.iterator();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Deprecated
    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean includeNamedQueriesScore() {
        return this.includeNamedQueriesScore;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Integer maxConcurrentSearches() {
        return this.maxConcurrentSearches;
    }

    @Nullable
    public final Integer maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    @Nullable
    public final Long preFilterShardSize() {
        return this.preFilterShardSize;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    public final List<RequestItem> searches() {
        return this.searches;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (RequestItem item0 : this.searches) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public static <TDocument> Endpoint<MsearchRequest, MsearchResponse<TDocument>, ErrorResponse> createMsearchEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(MsearchResponse.createMsearchResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MsearchRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeNamedQueriesScore;
        @Nullable
        private List<String> index;
        @Nullable
        private Integer maxConcurrentSearches;
        @Nullable
        private Integer maxConcurrentShardRequests;
        @Nullable
        private Long preFilterShardSize;
        @Nullable
        private String routing;
        @Nullable
        private SearchType searchType;
        private List<RequestItem> searches;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Deprecated
        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder includeNamedQueriesScore(@Nullable Boolean value) {
            this.includeNamedQueriesScore = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder maxConcurrentSearches(@Nullable Integer value) {
            this.maxConcurrentSearches = value;
            return this;
        }

        public final Builder maxConcurrentShardRequests(@Nullable Integer value) {
            this.maxConcurrentShardRequests = value;
            return this;
        }

        public final Builder preFilterShardSize(@Nullable Long value) {
            this.preFilterShardSize = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public final Builder searches(List<RequestItem> list) {
            this.searches = Builder._listAddAll(this.searches, list);
            return this;
        }

        public final Builder searches(RequestItem value, RequestItem ... values) {
            this.searches = Builder._listAdd(this.searches, value, values);
            return this;
        }

        public final Builder searches(Function<RequestItem.Builder, ObjectBuilder<RequestItem>> fn) {
            return this.searches(fn.apply(new RequestItem.Builder()).build(), new RequestItem[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MsearchRequest build() {
            this._checkSingleUse();
            return new MsearchRequest(this);
        }
    }
}

