/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level;

import co.elastic.clients.transport.rest5_client.low_level.Response;
import java.io.IOException;
import java.util.Locale;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public final class ResponseException
extends IOException {
    private final Response response;

    public ResponseException(Response response) throws IOException {
        super(ResponseException.buildMessage(response));
        this.response = response;
    }

    static String buildMessage(Response response) throws IOException {
        HttpEntity entity;
        Object message = String.format(Locale.ROOT, "method [%s], host [%s], URI [%s], status line [%s]", response.getRequestLine().getMethod(), response.getHost(), response.getRequestLine().getUri(), response.getStatusCode());
        if (response.hasWarnings()) {
            message = (String)message + "\nWarnings: " + String.valueOf(response.getWarnings());
        }
        if ((entity = response.getEntity()) != null) {
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
                response.getHttpResponse().setEntity(entity);
            }
            try {
                message = (String)message + "\n" + EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException e) {
                throw new IOException("Could not parse headers: " + String.valueOf((Object)e));
            }
        }
        return message;
    }

    public Response getResponse() {
        return this.response;
    }
}

