/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InputConfig
implements JsonpSerializable {
    private final String inputField;
    private final String outputField;
    public static final JsonpDeserializer<InputConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InputConfig::setupInputConfigDeserializer);

    private InputConfig(Builder builder) {
        this.inputField = ApiTypeHelper.requireNonNull(builder.inputField, this, "inputField");
        this.outputField = ApiTypeHelper.requireNonNull(builder.outputField, this, "outputField");
    }

    public static InputConfig of(Function<Builder, ObjectBuilder<InputConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inputField() {
        return this.inputField;
    }

    public final String outputField() {
        return this.outputField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("input_field");
        generator.write(this.inputField);
        generator.writeKey("output_field");
        generator.write(this.outputField);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInputConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inputField, JsonpDeserializer.stringDeserializer(), "input_field");
        op.add(Builder::outputField, JsonpDeserializer.stringDeserializer(), "output_field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InputConfig> {
        private String inputField;
        private String outputField;

        public final Builder inputField(String value) {
            this.inputField = value;
            return this;
        }

        public final Builder outputField(String value) {
            this.outputField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InputConfig build() {
            this._checkSingleUse();
            return new InputConfig(this);
        }
    }
}

