/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.ChunkingSettings;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SemanticTextProperty
implements PropertyVariant,
JsonpSerializable {
    private final Map<String, String> meta;
    @Nullable
    private final String inferenceId;
    @Nullable
    private final String searchInferenceId;
    @Nullable
    private final ChunkingSettings chunkingSettings;
    public static final JsonpDeserializer<SemanticTextProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SemanticTextProperty::setupSemanticTextPropertyDeserializer);

    private SemanticTextProperty(Builder builder) {
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.inferenceId = builder.inferenceId;
        this.searchInferenceId = builder.searchInferenceId;
        this.chunkingSettings = builder.chunkingSettings;
    }

    public static SemanticTextProperty of(Function<Builder, ObjectBuilder<SemanticTextProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.SemanticText;
    }

    public final Map<String, String> meta() {
        return this.meta;
    }

    @Nullable
    public final String inferenceId() {
        return this.inferenceId;
    }

    @Nullable
    public final String searchInferenceId() {
        return this.searchInferenceId;
    }

    @Nullable
    public final ChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "semantic_text");
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.inferenceId != null) {
            generator.writeKey("inference_id");
            generator.write(this.inferenceId);
        }
        if (this.searchInferenceId != null) {
            generator.writeKey("search_inference_id");
            generator.write(this.searchInferenceId);
        }
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSemanticTextPropertyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "meta");
        op.add(Builder::inferenceId, JsonpDeserializer.stringDeserializer(), "inference_id");
        op.add(Builder::searchInferenceId, JsonpDeserializer.stringDeserializer(), "search_inference_id");
        op.add(Builder::chunkingSettings, ChunkingSettings._DESERIALIZER, "chunking_settings");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SemanticTextProperty> {
        @Nullable
        private Map<String, String> meta;
        @Nullable
        private String inferenceId;
        @Nullable
        private String searchInferenceId;
        @Nullable
        private ChunkingSettings chunkingSettings;

        public final Builder meta(Map<String, String> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, String value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder inferenceId(@Nullable String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder searchInferenceId(@Nullable String value) {
            this.searchInferenceId = value;
            return this;
        }

        public final Builder chunkingSettings(@Nullable ChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<ChunkingSettings.Builder, ObjectBuilder<ChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new ChunkingSettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SemanticTextProperty build() {
            this._checkSingleUse();
            return new SemanticTextProperty(this);
        }
    }
}

