/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.indices.IndicesRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class IndicesResponse
implements JsonpSerializable {
    private final List<IndicesRecord> indices;
    public static final JsonpDeserializer<IndicesResponse> _DESERIALIZER = IndicesResponse.createIndicesResponseDeserializer();

    private IndicesResponse(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static IndicesResponse of(Function<Builder, ObjectBuilder<IndicesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<IndicesRecord> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (IndicesRecord item0 : this.indices) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<IndicesResponse> createIndicesResponseDeserializer() {
        JsonpDeserializer<List<IndicesRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(IndicesRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().indices((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndicesResponse> {
        private List<IndicesRecord> indices;

        public final Builder indices(List<IndicesRecord> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(IndicesRecord value, IndicesRecord ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<IndicesRecord.Builder, ObjectBuilder<IndicesRecord>> fn) {
            return this.indices(fn.apply(new IndicesRecord.Builder()).build(), new IndicesRecord[0]);
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            List<IndicesRecord> value = JsonpDeserializer.arrayDeserializer(IndicesRecord._DESERIALIZER).deserialize(parser, mapper);
            return this.indices(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndicesResponse build() {
            this._checkSingleUse();
            return new IndicesResponse(this);
        }
    }
}

