/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.InnerRetriever;
import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LinearRetriever
extends RetrieverBase
implements RetrieverVariant {
    private final List<InnerRetriever> retrievers;
    @Nullable
    private final Integer rankWindowSize;
    public static final JsonpDeserializer<LinearRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LinearRetriever::setupLinearRetrieverDeserializer);

    private LinearRetriever(Builder builder) {
        super(builder);
        this.retrievers = ApiTypeHelper.unmodifiable(builder.retrievers);
        this.rankWindowSize = builder.rankWindowSize;
    }

    public static LinearRetriever of(Function<Builder, ObjectBuilder<LinearRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Linear;
    }

    public final List<InnerRetriever> retrievers() {
        return this.retrievers;
    }

    @Nullable
    public final Integer rankWindowSize() {
        return this.rankWindowSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.retrievers)) {
            generator.writeKey("retrievers");
            generator.writeStartArray();
            for (InnerRetriever item0 : this.retrievers) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.rankWindowSize != null) {
            generator.writeKey("rank_window_size");
            generator.write(this.rankWindowSize.intValue());
        }
    }

    protected static void setupLinearRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::retrievers, JsonpDeserializer.arrayDeserializer(InnerRetriever._DESERIALIZER), "retrievers");
        op.add(Builder::rankWindowSize, JsonpDeserializer.integerDeserializer(), "rank_window_size");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LinearRetriever> {
        @Nullable
        private List<InnerRetriever> retrievers;
        @Nullable
        private Integer rankWindowSize;

        public final Builder retrievers(List<InnerRetriever> list) {
            this.retrievers = Builder._listAddAll(this.retrievers, list);
            return this;
        }

        public final Builder retrievers(InnerRetriever value, InnerRetriever ... values) {
            this.retrievers = Builder._listAdd(this.retrievers, value, values);
            return this;
        }

        public final Builder retrievers(Function<InnerRetriever.Builder, ObjectBuilder<InnerRetriever>> fn) {
            return this.retrievers(fn.apply(new InnerRetriever.Builder()).build(), new InnerRetriever[0]);
        }

        public final Builder rankWindowSize(@Nullable Integer value) {
            this.rankWindowSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LinearRetriever build() {
            this._checkSingleUse();
            return new LinearRetriever(this);
        }
    }
}

