/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules;

import co.elastic.clients.elasticsearch.query_rules.QueryRuleActions;
import co.elastic.clients.elasticsearch.query_rules.QueryRuleCriteria;
import co.elastic.clients.elasticsearch.query_rules.QueryRuleType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryRule
implements JsonpSerializable {
    private final String ruleId;
    private final QueryRuleType type;
    private final List<QueryRuleCriteria> criteria;
    private final QueryRuleActions actions;
    @Nullable
    private final Integer priority;
    public static final JsonpDeserializer<QueryRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRule::setupQueryRuleDeserializer);

    protected QueryRule(AbstractBuilder<?> builder) {
        this.ruleId = ApiTypeHelper.requireNonNull(builder.ruleId, this, "ruleId");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.criteria = ApiTypeHelper.unmodifiableRequired(builder.criteria, (Object)this, "criteria");
        this.actions = ApiTypeHelper.requireNonNull(builder.actions, this, "actions");
        this.priority = builder.priority;
    }

    public static QueryRule queryRuleOf(Function<Builder, ObjectBuilder<QueryRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final QueryRuleType type() {
        return this.type;
    }

    public final List<QueryRuleCriteria> criteria() {
        return this.criteria;
    }

    public final QueryRuleActions actions() {
        return this.actions;
    }

    @Nullable
    public final Integer priority() {
        return this.priority;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rule_id");
        generator.write(this.ruleId);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.criteria)) {
            generator.writeKey("criteria");
            generator.writeStartArray();
            for (QueryRuleCriteria item0 : this.criteria) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("actions");
        this.actions.serialize(generator, mapper);
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupQueryRuleDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::ruleId, JsonpDeserializer.stringDeserializer(), "rule_id");
        op.add(AbstractBuilder::type, QueryRuleType._DESERIALIZER, "type");
        op.add(AbstractBuilder::criteria, JsonpDeserializer.arrayDeserializer(QueryRuleCriteria._DESERIALIZER), "criteria");
        op.add(AbstractBuilder::actions, QueryRuleActions._DESERIALIZER, "actions");
        op.add(AbstractBuilder::priority, JsonpDeserializer.integerDeserializer(), "priority");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String ruleId;
        private QueryRuleType type;
        private List<QueryRuleCriteria> criteria;
        private QueryRuleActions actions;
        @Nullable
        private Integer priority;

        public final BuilderT ruleId(String value) {
            this.ruleId = value;
            return (BuilderT)this.self();
        }

        public final BuilderT type(QueryRuleType value) {
            this.type = value;
            return (BuilderT)this.self();
        }

        public final BuilderT criteria(List<QueryRuleCriteria> list) {
            this.criteria = AbstractBuilder._listAddAll(this.criteria, list);
            return (BuilderT)this.self();
        }

        public final BuilderT criteria(QueryRuleCriteria value, QueryRuleCriteria ... values) {
            this.criteria = AbstractBuilder._listAdd(this.criteria, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT criteria(Function<QueryRuleCriteria.Builder, ObjectBuilder<QueryRuleCriteria>> fn) {
            return this.criteria(fn.apply(new QueryRuleCriteria.Builder()).build(), new QueryRuleCriteria[0]);
        }

        public final BuilderT actions(QueryRuleActions value) {
            this.actions = value;
            return (BuilderT)this.self();
        }

        public final BuilderT actions(Function<QueryRuleActions.Builder, ObjectBuilder<QueryRuleActions>> fn) {
            return this.actions(fn.apply(new QueryRuleActions.Builder()).build());
        }

        public final BuilderT priority(@Nullable Integer value) {
            this.priority = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<QueryRule> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRule build() {
            this._checkSingleUse();
            return new QueryRule(this);
        }
    }
}

