/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PreviewDatafeedResponse<TDocument>
implements JsonpSerializable {
    private final List<TDocument> documents;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<PreviewDatafeedResponse<Object>> _DESERIALIZER = PreviewDatafeedResponse.createPreviewDatafeedResponseDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:ml.preview_datafeed.Response.TDocument"));

    private PreviewDatafeedResponse(Builder<TDocument> builder) {
        this.documents = ApiTypeHelper.unmodifiableRequired(builder.documents, (Object)this, "documents");
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    public static <TDocument> PreviewDatafeedResponse<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<PreviewDatafeedResponse<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<TDocument> documents() {
        return this.documents;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (TDocument item0 : this.documents) {
            JsonpUtils.serialize(item0, generator, this.tDocumentSerializer, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <TDocument> JsonpDeserializer<PreviewDatafeedResponse<TDocument>> createPreviewDatafeedResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        JsonpDeserializer valueDeserializer = JsonpDeserializer.arrayDeserializer(tDocumentDeserializer);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().documents((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder<TDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument>>
    implements ObjectBuilder<PreviewDatafeedResponse<TDocument>> {
        private List<TDocument> documents;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> documents(List<TDocument> list) {
            this.documents = Builder._listAddAll(this.documents, list);
            return this;
        }

        public final Builder<TDocument> documents(TDocument value, TDocument ... values) {
            this.documents = Builder._listAdd(this.documents, value, values);
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public Builder<TDocument> withJson(JsonParser parser, JsonpMapper mapper) {
            JsonpDeserializer<JsonData> tDocumentDeserializer = JsonData._DESERIALIZER;
            List<JsonData> value = JsonpDeserializer.arrayDeserializer(tDocumentDeserializer).deserialize(parser, mapper);
            return this.documents(value);
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public PreviewDatafeedResponse<TDocument> build() {
            this._checkSingleUse();
            return new PreviewDatafeedResponse(this);
        }
    }
}

